/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.follow_info;

import co.elastic.clients.elasticsearch.ccr.follow_info.FollowerIndexParameters;
import co.elastic.clients.elasticsearch.ccr.follow_info.FollowerIndexStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FollowerIndex
implements JsonpSerializable {
    private final String followerIndex;
    private final String leaderIndex;
    @Nullable
    private final FollowerIndexParameters parameters;
    private final String remoteCluster;
    private final FollowerIndexStatus status;
    public static final JsonpDeserializer<FollowerIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowerIndex::setupFollowerIndexDeserializer, Builder::build);

    public FollowerIndex(Builder builder) {
        this.followerIndex = Objects.requireNonNull(builder.followerIndex, "follower_index");
        this.leaderIndex = Objects.requireNonNull(builder.leaderIndex, "leader_index");
        this.parameters = builder.parameters;
        this.remoteCluster = Objects.requireNonNull(builder.remoteCluster, "remote_cluster");
        this.status = Objects.requireNonNull(builder.status, "status");
    }

    public FollowerIndex(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String followerIndex() {
        return this.followerIndex;
    }

    public String leaderIndex() {
        return this.leaderIndex;
    }

    @Nullable
    public FollowerIndexParameters parameters() {
        return this.parameters;
    }

    public String remoteCluster() {
        return this.remoteCluster;
    }

    public FollowerIndexStatus status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("follower_index");
        generator.write(this.followerIndex);
        generator.writeKey("leader_index");
        generator.write(this.leaderIndex);
        if (this.parameters != null) {
            generator.writeKey("parameters");
            this.parameters.serialize(generator, mapper);
        }
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
    }

    protected static void setupFollowerIndexDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::followerIndex, JsonpDeserializer.stringDeserializer(), "follower_index", new String[0]);
        op.add(Builder::leaderIndex, JsonpDeserializer.stringDeserializer(), "leader_index", new String[0]);
        op.add(Builder::parameters, FollowerIndexParameters._DESERIALIZER, "parameters", new String[0]);
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster", new String[0]);
        op.add(Builder::status, FollowerIndexStatus._DESERIALIZER, "status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FollowerIndex> {
        private String followerIndex;
        private String leaderIndex;
        @Nullable
        private FollowerIndexParameters parameters;
        private String remoteCluster;
        private FollowerIndexStatus status;

        public Builder followerIndex(String value) {
            this.followerIndex = value;
            return this;
        }

        public Builder leaderIndex(String value) {
            this.leaderIndex = value;
            return this;
        }

        public Builder parameters(@Nullable FollowerIndexParameters value) {
            this.parameters = value;
            return this;
        }

        public Builder parameters(Function<FollowerIndexParameters.Builder, ObjectBuilder<FollowerIndexParameters>> fn) {
            return this.parameters(fn.apply(new FollowerIndexParameters.Builder()).build());
        }

        public Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public Builder status(FollowerIndexStatus value) {
            this.status = value;
            return this;
        }

        @Override
        public FollowerIndex build() {
            return new FollowerIndex(this);
        }
    }
}

