/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ccr.GetAutoFollowPatternResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetAutoFollowPatternRequest
extends RequestBase {
    @Nullable
    private final String name;
    public static final Endpoint<GetAutoFollowPatternRequest, GetAutoFollowPatternResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetAutoFollowPatternRequest, GetAutoFollowPatternResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ccr");
            buf.append("/auto_follow");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ccr");
            buf.append("/auto_follow");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetAutoFollowPatternResponse._DESERIALIZER);

    public GetAutoFollowPatternRequest(Builder builder) {
        this.name = builder.name;
    }

    public GetAutoFollowPatternRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public static class Builder
    implements ObjectBuilder<GetAutoFollowPatternRequest> {
        @Nullable
        private String name;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public GetAutoFollowPatternRequest build() {
            return new GetAutoFollowPatternRequest(this);
        }
    }
}

