/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.Health;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.IndicesResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class IndicesRequest
extends CatRequestBase {
    @Nullable
    private final List<String> index;
    @Nullable
    private final Bytes bytes;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Health health;
    @Nullable
    private final Boolean includeUnloadedSegments;
    @Nullable
    private final Boolean pri;
    public static final Endpoint<IndicesRequest, IndicesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<IndicesRequest, IndicesResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/indices");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/indices");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.bytes != null) {
            params.put("bytes", request.bytes.toString());
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.health != null) {
            params.put("health", request.health.toString());
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        if (request.pri != null) {
            params.put("pri", String.valueOf(request.pri));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, IndicesResponse._DESERIALIZER);

    public IndicesRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.bytes = builder.bytes;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.health = builder.health;
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
        this.pri = builder.pri;
    }

    public IndicesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Bytes bytes() {
        return this.bytes;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Health health() {
        return this.health;
    }

    @Nullable
    public Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    @Nullable
    public Boolean pri() {
        return this.pri;
    }

    public static class Builder
    implements ObjectBuilder<IndicesRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Health health;
        @Nullable
        private Boolean includeUnloadedSegments;
        @Nullable
        private Boolean pri;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder health(@Nullable Health value) {
            this.health = value;
            return this;
        }

        public Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        public Builder pri(@Nullable Boolean value) {
            this.pri = value;
            return this;
        }

        @Override
        public IndicesRequest build() {
            return new IndicesRequest(this);
        }
    }
}

