/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RankFeatureFunction;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RankFeatureFunctionSigmoid
extends RankFeatureFunction
implements JsonpSerializable {
    private final float pivot;
    private final float exponent;
    public static final JsonpDeserializer<RankFeatureFunctionSigmoid> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankFeatureFunctionSigmoid::setupRankFeatureFunctionSigmoidDeserializer, Builder::build);

    public RankFeatureFunctionSigmoid(Builder builder) {
        this.pivot = Objects.requireNonNull(builder.pivot, "pivot").floatValue();
        this.exponent = Objects.requireNonNull(builder.exponent, "exponent").floatValue();
    }

    public RankFeatureFunctionSigmoid(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public float pivot() {
        return this.pivot;
    }

    public float exponent() {
        return this.exponent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pivot");
        generator.write((double)this.pivot);
        generator.writeKey("exponent");
        generator.write((double)this.exponent);
    }

    protected static void setupRankFeatureFunctionSigmoidDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::pivot, JsonpDeserializer.floatDeserializer(), "pivot", new String[0]);
        op.add(Builder::exponent, JsonpDeserializer.floatDeserializer(), "exponent", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RankFeatureFunctionSigmoid> {
        private Float pivot;
        private Float exponent;

        public Builder pivot(float value) {
            this.pivot = Float.valueOf(value);
            return this;
        }

        public Builder exponent(float value) {
            this.exponent = Float.valueOf(value);
            return this;
        }

        @Override
        public RankFeatureFunctionSigmoid build() {
            return new RankFeatureFunctionSigmoid(this);
        }
    }
}

