/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AsciiFoldingTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.CommonGramsTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ConditionTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.DelimitedPayloadTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.EdgeNGramTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ElisionTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.FingerprintTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.HunspellTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.HyphenationDecompounderTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KStemTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KeepTypesTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KeepWordsTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KeywordMarkerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiPartOfSpeechTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiReadingFormTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiStemmerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.LengthTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.LimitTokenCountTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.LowercaseTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.MultiplexerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.NGramTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.NoriPartOfSpeechTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PatternCaptureTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PatternReplaceTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PorterStemTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.PredicateTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.RemoveDuplicatesTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ReverseTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.ShingleTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.SnowballTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.StemmerOverrideTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.StemmerTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.StopTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.SynonymGraphTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.SynonymTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.elasticsearch._types.analysis.TrimTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.TruncateTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.UniqueTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.UppercaseTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.WordDelimiterGraphTokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.WordDelimiterTokenFilter;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class TokenFilter
implements TaggedUnion<JsonpSerializable>,
JsonpSerializable {
    public static final String ASCIIFOLDING = "asciifolding";
    public static final String COMMON_GRAMS = "common_grams";
    public static final String CONDITION = "condition";
    public static final String DELIMITED_PAYLOAD = "delimited_payload";
    public static final String EDGE_NGRAM = "edge_ngram";
    public static final String ELISION = "elision";
    public static final String FINGERPRINT = "fingerprint";
    public static final String HUNSPELL = "hunspell";
    public static final String HYPHENATION_DECOMPOUNDER = "hyphenation_decompounder";
    public static final String KSTEM = "kstem";
    public static final String KEEP_TYPES = "keep_types";
    public static final String KEEP = "keep";
    public static final String KEYWORD_MARKER = "keyword_marker";
    public static final String KUROMOJI_PART_OF_SPEECH = "kuromoji_part_of_speech";
    public static final String KUROMOJI_READINGFORM = "kuromoji_readingform";
    public static final String KUROMOJI_STEMMER = "kuromoji_stemmer";
    public static final String LENGTH = "length";
    public static final String LIMIT = "limit";
    public static final String LOWERCASE = "lowercase";
    public static final String MULTIPLEXER = "multiplexer";
    public static final String NGRAM = "ngram";
    public static final String NORI_PART_OF_SPEECH = "nori_part_of_speech";
    public static final String PATTERN_CAPTURE = "pattern_capture";
    public static final String PATTERN_REPLACE = "pattern_replace";
    public static final String PORTER_STEM = "porter_stem";
    public static final String PREDICATE_TOKEN_FILTER = "predicate_token_filter";
    public static final String REMOVE_DUPLICATES = "remove_duplicates";
    public static final String REVERSE = "reverse";
    public static final String SHINGLE = "shingle";
    public static final String SNOWBALL = "snowball";
    public static final String STEMMER_OVERRIDE = "stemmer_override";
    public static final String STEMMER = "stemmer";
    public static final String STOP = "stop";
    public static final String SYNONYM_GRAPH = "synonym_graph";
    public static final String SYNONYM = "synonym";
    public static final String TRIM = "trim";
    public static final String TRUNCATE = "truncate";
    public static final String UNIQUE = "unique";
    public static final String UPPERCASE = "uppercase";
    public static final String WORD_DELIMITER_GRAPH = "word_delimiter_graph";
    public static final String WORD_DELIMITER = "word_delimiter";
    private final String _type;
    private final JsonpSerializable _value;
    public static final JsonpDeserializer<TokenFilter> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, TokenFilter::setupTokenFilterDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public JsonpSerializable _get() {
        return this._value;
    }

    public TokenFilter(TokenFilterVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    public <T extends TokenFilterVariant> TokenFilter(ObjectBuilder<T> builder) {
        this((TokenFilterVariant)builder.build());
    }

    private TokenFilter(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public TokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AsciiFoldingTokenFilter asciifolding() {
        return (AsciiFoldingTokenFilter)TaggedUnionUtils.get(this, ASCIIFOLDING);
    }

    public CommonGramsTokenFilter commonGrams() {
        return (CommonGramsTokenFilter)TaggedUnionUtils.get(this, COMMON_GRAMS);
    }

    public ConditionTokenFilter condition() {
        return (ConditionTokenFilter)TaggedUnionUtils.get(this, CONDITION);
    }

    public DelimitedPayloadTokenFilter delimitedPayload() {
        return (DelimitedPayloadTokenFilter)TaggedUnionUtils.get(this, DELIMITED_PAYLOAD);
    }

    public EdgeNGramTokenFilter edgeNgram() {
        return (EdgeNGramTokenFilter)TaggedUnionUtils.get(this, EDGE_NGRAM);
    }

    public ElisionTokenFilter elision() {
        return (ElisionTokenFilter)TaggedUnionUtils.get(this, ELISION);
    }

    public FingerprintTokenFilter fingerprint() {
        return (FingerprintTokenFilter)TaggedUnionUtils.get(this, FINGERPRINT);
    }

    public HunspellTokenFilter hunspell() {
        return (HunspellTokenFilter)TaggedUnionUtils.get(this, HUNSPELL);
    }

    public HyphenationDecompounderTokenFilter hyphenationDecompounder() {
        return (HyphenationDecompounderTokenFilter)TaggedUnionUtils.get(this, HYPHENATION_DECOMPOUNDER);
    }

    public KStemTokenFilter kstem() {
        return (KStemTokenFilter)TaggedUnionUtils.get(this, KSTEM);
    }

    public KeepTypesTokenFilter keepTypes() {
        return (KeepTypesTokenFilter)TaggedUnionUtils.get(this, KEEP_TYPES);
    }

    public KeepWordsTokenFilter keep() {
        return (KeepWordsTokenFilter)TaggedUnionUtils.get(this, KEEP);
    }

    public KeywordMarkerTokenFilter keywordMarker() {
        return (KeywordMarkerTokenFilter)TaggedUnionUtils.get(this, KEYWORD_MARKER);
    }

    public KuromojiPartOfSpeechTokenFilter kuromojiPartOfSpeech() {
        return (KuromojiPartOfSpeechTokenFilter)TaggedUnionUtils.get(this, KUROMOJI_PART_OF_SPEECH);
    }

    public KuromojiReadingFormTokenFilter kuromojiReadingform() {
        return (KuromojiReadingFormTokenFilter)TaggedUnionUtils.get(this, KUROMOJI_READINGFORM);
    }

    public KuromojiStemmerTokenFilter kuromojiStemmer() {
        return (KuromojiStemmerTokenFilter)TaggedUnionUtils.get(this, KUROMOJI_STEMMER);
    }

    public LengthTokenFilter length() {
        return (LengthTokenFilter)TaggedUnionUtils.get(this, LENGTH);
    }

    public LimitTokenCountTokenFilter limit() {
        return (LimitTokenCountTokenFilter)TaggedUnionUtils.get(this, LIMIT);
    }

    public LowercaseTokenFilter lowercase() {
        return (LowercaseTokenFilter)TaggedUnionUtils.get(this, LOWERCASE);
    }

    public MultiplexerTokenFilter multiplexer() {
        return (MultiplexerTokenFilter)TaggedUnionUtils.get(this, MULTIPLEXER);
    }

    public NGramTokenFilter ngram() {
        return (NGramTokenFilter)TaggedUnionUtils.get(this, NGRAM);
    }

    public NoriPartOfSpeechTokenFilter noriPartOfSpeech() {
        return (NoriPartOfSpeechTokenFilter)TaggedUnionUtils.get(this, NORI_PART_OF_SPEECH);
    }

    public PatternCaptureTokenFilter patternCapture() {
        return (PatternCaptureTokenFilter)TaggedUnionUtils.get(this, PATTERN_CAPTURE);
    }

    public PatternReplaceTokenFilter patternReplace() {
        return (PatternReplaceTokenFilter)TaggedUnionUtils.get(this, PATTERN_REPLACE);
    }

    public PorterStemTokenFilter porterStem() {
        return (PorterStemTokenFilter)TaggedUnionUtils.get(this, PORTER_STEM);
    }

    public PredicateTokenFilter predicateTokenFilter() {
        return (PredicateTokenFilter)TaggedUnionUtils.get(this, PREDICATE_TOKEN_FILTER);
    }

    public RemoveDuplicatesTokenFilter removeDuplicates() {
        return (RemoveDuplicatesTokenFilter)TaggedUnionUtils.get(this, REMOVE_DUPLICATES);
    }

    public ReverseTokenFilter reverse() {
        return (ReverseTokenFilter)TaggedUnionUtils.get(this, REVERSE);
    }

    public ShingleTokenFilter shingle() {
        return (ShingleTokenFilter)TaggedUnionUtils.get(this, SHINGLE);
    }

    public SnowballTokenFilter snowball() {
        return (SnowballTokenFilter)TaggedUnionUtils.get(this, SNOWBALL);
    }

    public StemmerOverrideTokenFilter stemmerOverride() {
        return (StemmerOverrideTokenFilter)TaggedUnionUtils.get(this, STEMMER_OVERRIDE);
    }

    public StemmerTokenFilter stemmer() {
        return (StemmerTokenFilter)TaggedUnionUtils.get(this, STEMMER);
    }

    public StopTokenFilter stop() {
        return (StopTokenFilter)TaggedUnionUtils.get(this, STOP);
    }

    public SynonymGraphTokenFilter synonymGraph() {
        return (SynonymGraphTokenFilter)TaggedUnionUtils.get(this, SYNONYM_GRAPH);
    }

    public SynonymTokenFilter synonym() {
        return (SynonymTokenFilter)TaggedUnionUtils.get(this, SYNONYM);
    }

    public TrimTokenFilter trim() {
        return (TrimTokenFilter)TaggedUnionUtils.get(this, TRIM);
    }

    public TruncateTokenFilter truncate() {
        return (TruncateTokenFilter)TaggedUnionUtils.get(this, TRUNCATE);
    }

    public UniqueTokenFilter unique() {
        return (UniqueTokenFilter)TaggedUnionUtils.get(this, UNIQUE);
    }

    public UppercaseTokenFilter uppercase() {
        return (UppercaseTokenFilter)TaggedUnionUtils.get(this, UPPERCASE);
    }

    public WordDelimiterGraphTokenFilter wordDelimiterGraph() {
        return (WordDelimiterGraphTokenFilter)TaggedUnionUtils.get(this, WORD_DELIMITER_GRAPH);
    }

    public WordDelimiterTokenFilter wordDelimiter() {
        return (WordDelimiterTokenFilter)TaggedUnionUtils.get(this, WORD_DELIMITER);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this._value.serialize(generator, mapper);
    }

    protected static void setupTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::asciifolding, AsciiFoldingTokenFilter._DESERIALIZER, ASCIIFOLDING, new String[0]);
        op.add(Builder::commonGrams, CommonGramsTokenFilter._DESERIALIZER, COMMON_GRAMS, new String[0]);
        op.add(Builder::condition, ConditionTokenFilter._DESERIALIZER, CONDITION, new String[0]);
        op.add(Builder::delimitedPayload, DelimitedPayloadTokenFilter._DESERIALIZER, DELIMITED_PAYLOAD, new String[0]);
        op.add(Builder::edgeNgram, EdgeNGramTokenFilter._DESERIALIZER, EDGE_NGRAM, new String[0]);
        op.add(Builder::elision, ElisionTokenFilter._DESERIALIZER, ELISION, new String[0]);
        op.add(Builder::fingerprint, FingerprintTokenFilter._DESERIALIZER, FINGERPRINT, new String[0]);
        op.add(Builder::hunspell, HunspellTokenFilter._DESERIALIZER, HUNSPELL, new String[0]);
        op.add(Builder::hyphenationDecompounder, HyphenationDecompounderTokenFilter._DESERIALIZER, HYPHENATION_DECOMPOUNDER, new String[0]);
        op.add(Builder::kstem, KStemTokenFilter._DESERIALIZER, KSTEM, new String[0]);
        op.add(Builder::keepTypes, KeepTypesTokenFilter._DESERIALIZER, KEEP_TYPES, new String[0]);
        op.add(Builder::keep, KeepWordsTokenFilter._DESERIALIZER, KEEP, new String[0]);
        op.add(Builder::keywordMarker, KeywordMarkerTokenFilter._DESERIALIZER, KEYWORD_MARKER, new String[0]);
        op.add(Builder::kuromojiPartOfSpeech, KuromojiPartOfSpeechTokenFilter._DESERIALIZER, KUROMOJI_PART_OF_SPEECH, new String[0]);
        op.add(Builder::kuromojiReadingform, KuromojiReadingFormTokenFilter._DESERIALIZER, KUROMOJI_READINGFORM, new String[0]);
        op.add(Builder::kuromojiStemmer, KuromojiStemmerTokenFilter._DESERIALIZER, KUROMOJI_STEMMER, new String[0]);
        op.add(Builder::length, LengthTokenFilter._DESERIALIZER, LENGTH, new String[0]);
        op.add(Builder::limit, LimitTokenCountTokenFilter._DESERIALIZER, LIMIT, new String[0]);
        op.add(Builder::lowercase, LowercaseTokenFilter._DESERIALIZER, LOWERCASE, new String[0]);
        op.add(Builder::multiplexer, MultiplexerTokenFilter._DESERIALIZER, MULTIPLEXER, new String[0]);
        op.add(Builder::ngram, NGramTokenFilter._DESERIALIZER, NGRAM, new String[0]);
        op.add(Builder::noriPartOfSpeech, NoriPartOfSpeechTokenFilter._DESERIALIZER, NORI_PART_OF_SPEECH, new String[0]);
        op.add(Builder::patternCapture, PatternCaptureTokenFilter._DESERIALIZER, PATTERN_CAPTURE, new String[0]);
        op.add(Builder::patternReplace, PatternReplaceTokenFilter._DESERIALIZER, PATTERN_REPLACE, new String[0]);
        op.add(Builder::porterStem, PorterStemTokenFilter._DESERIALIZER, PORTER_STEM, new String[0]);
        op.add(Builder::predicateTokenFilter, PredicateTokenFilter._DESERIALIZER, PREDICATE_TOKEN_FILTER, new String[0]);
        op.add(Builder::removeDuplicates, RemoveDuplicatesTokenFilter._DESERIALIZER, REMOVE_DUPLICATES, new String[0]);
        op.add(Builder::reverse, ReverseTokenFilter._DESERIALIZER, REVERSE, new String[0]);
        op.add(Builder::shingle, ShingleTokenFilter._DESERIALIZER, SHINGLE, new String[0]);
        op.add(Builder::snowball, SnowballTokenFilter._DESERIALIZER, SNOWBALL, new String[0]);
        op.add(Builder::stemmerOverride, StemmerOverrideTokenFilter._DESERIALIZER, STEMMER_OVERRIDE, new String[0]);
        op.add(Builder::stemmer, StemmerTokenFilter._DESERIALIZER, STEMMER, new String[0]);
        op.add(Builder::stop, StopTokenFilter._DESERIALIZER, STOP, new String[0]);
        op.add(Builder::synonymGraph, SynonymGraphTokenFilter._DESERIALIZER, SYNONYM_GRAPH, new String[0]);
        op.add(Builder::synonym, SynonymTokenFilter._DESERIALIZER, SYNONYM, new String[0]);
        op.add(Builder::trim, TrimTokenFilter._DESERIALIZER, TRIM, new String[0]);
        op.add(Builder::truncate, TruncateTokenFilter._DESERIALIZER, TRUNCATE, new String[0]);
        op.add(Builder::unique, UniqueTokenFilter._DESERIALIZER, UNIQUE, new String[0]);
        op.add(Builder::uppercase, UppercaseTokenFilter._DESERIALIZER, UPPERCASE, new String[0]);
        op.add(Builder::wordDelimiterGraph, WordDelimiterGraphTokenFilter._DESERIALIZER, WORD_DELIMITER_GRAPH, new String[0]);
        op.add(Builder::wordDelimiter, WordDelimiterTokenFilter._DESERIALIZER, WORD_DELIMITER, new String[0]);
        op.setTypeProperty("type");
    }

    public static class Builder
    implements ObjectBuilder<TokenFilter> {
        private String _type;
        private JsonpSerializable _value;

        public Builder asciifolding(AsciiFoldingTokenFilter v) {
            this._type = TokenFilter.ASCIIFOLDING;
            this._value = v;
            return this;
        }

        public Builder asciifolding(Function<AsciiFoldingTokenFilter.Builder, ObjectBuilder<AsciiFoldingTokenFilter>> f) {
            return this.asciifolding(f.apply(new AsciiFoldingTokenFilter.Builder()).build());
        }

        public Builder commonGrams(CommonGramsTokenFilter v) {
            this._type = TokenFilter.COMMON_GRAMS;
            this._value = v;
            return this;
        }

        public Builder commonGrams(Function<CommonGramsTokenFilter.Builder, ObjectBuilder<CommonGramsTokenFilter>> f) {
            return this.commonGrams(f.apply(new CommonGramsTokenFilter.Builder()).build());
        }

        public Builder condition(ConditionTokenFilter v) {
            this._type = TokenFilter.CONDITION;
            this._value = v;
            return this;
        }

        public Builder condition(Function<ConditionTokenFilter.Builder, ObjectBuilder<ConditionTokenFilter>> f) {
            return this.condition(f.apply(new ConditionTokenFilter.Builder()).build());
        }

        public Builder delimitedPayload(DelimitedPayloadTokenFilter v) {
            this._type = TokenFilter.DELIMITED_PAYLOAD;
            this._value = v;
            return this;
        }

        public Builder delimitedPayload(Function<DelimitedPayloadTokenFilter.Builder, ObjectBuilder<DelimitedPayloadTokenFilter>> f) {
            return this.delimitedPayload(f.apply(new DelimitedPayloadTokenFilter.Builder()).build());
        }

        public Builder edgeNgram(EdgeNGramTokenFilter v) {
            this._type = TokenFilter.EDGE_NGRAM;
            this._value = v;
            return this;
        }

        public Builder edgeNgram(Function<EdgeNGramTokenFilter.Builder, ObjectBuilder<EdgeNGramTokenFilter>> f) {
            return this.edgeNgram(f.apply(new EdgeNGramTokenFilter.Builder()).build());
        }

        public Builder elision(ElisionTokenFilter v) {
            this._type = TokenFilter.ELISION;
            this._value = v;
            return this;
        }

        public Builder elision(Function<ElisionTokenFilter.Builder, ObjectBuilder<ElisionTokenFilter>> f) {
            return this.elision(f.apply(new ElisionTokenFilter.Builder()).build());
        }

        public Builder fingerprint(FingerprintTokenFilter v) {
            this._type = TokenFilter.FINGERPRINT;
            this._value = v;
            return this;
        }

        public Builder fingerprint(Function<FingerprintTokenFilter.Builder, ObjectBuilder<FingerprintTokenFilter>> f) {
            return this.fingerprint(f.apply(new FingerprintTokenFilter.Builder()).build());
        }

        public Builder hunspell(HunspellTokenFilter v) {
            this._type = TokenFilter.HUNSPELL;
            this._value = v;
            return this;
        }

        public Builder hunspell(Function<HunspellTokenFilter.Builder, ObjectBuilder<HunspellTokenFilter>> f) {
            return this.hunspell(f.apply(new HunspellTokenFilter.Builder()).build());
        }

        public Builder hyphenationDecompounder(HyphenationDecompounderTokenFilter v) {
            this._type = TokenFilter.HYPHENATION_DECOMPOUNDER;
            this._value = v;
            return this;
        }

        public Builder hyphenationDecompounder(Function<HyphenationDecompounderTokenFilter.Builder, ObjectBuilder<HyphenationDecompounderTokenFilter>> f) {
            return this.hyphenationDecompounder(f.apply(new HyphenationDecompounderTokenFilter.Builder()).build());
        }

        public Builder kstem(KStemTokenFilter v) {
            this._type = TokenFilter.KSTEM;
            this._value = v;
            return this;
        }

        public Builder kstem(Function<KStemTokenFilter.Builder, ObjectBuilder<KStemTokenFilter>> f) {
            return this.kstem(f.apply(new KStemTokenFilter.Builder()).build());
        }

        public Builder keepTypes(KeepTypesTokenFilter v) {
            this._type = TokenFilter.KEEP_TYPES;
            this._value = v;
            return this;
        }

        public Builder keepTypes(Function<KeepTypesTokenFilter.Builder, ObjectBuilder<KeepTypesTokenFilter>> f) {
            return this.keepTypes(f.apply(new KeepTypesTokenFilter.Builder()).build());
        }

        public Builder keep(KeepWordsTokenFilter v) {
            this._type = TokenFilter.KEEP;
            this._value = v;
            return this;
        }

        public Builder keep(Function<KeepWordsTokenFilter.Builder, ObjectBuilder<KeepWordsTokenFilter>> f) {
            return this.keep(f.apply(new KeepWordsTokenFilter.Builder()).build());
        }

        public Builder keywordMarker(KeywordMarkerTokenFilter v) {
            this._type = TokenFilter.KEYWORD_MARKER;
            this._value = v;
            return this;
        }

        public Builder keywordMarker(Function<KeywordMarkerTokenFilter.Builder, ObjectBuilder<KeywordMarkerTokenFilter>> f) {
            return this.keywordMarker(f.apply(new KeywordMarkerTokenFilter.Builder()).build());
        }

        public Builder kuromojiPartOfSpeech(KuromojiPartOfSpeechTokenFilter v) {
            this._type = TokenFilter.KUROMOJI_PART_OF_SPEECH;
            this._value = v;
            return this;
        }

        public Builder kuromojiPartOfSpeech(Function<KuromojiPartOfSpeechTokenFilter.Builder, ObjectBuilder<KuromojiPartOfSpeechTokenFilter>> f) {
            return this.kuromojiPartOfSpeech(f.apply(new KuromojiPartOfSpeechTokenFilter.Builder()).build());
        }

        public Builder kuromojiReadingform(KuromojiReadingFormTokenFilter v) {
            this._type = TokenFilter.KUROMOJI_READINGFORM;
            this._value = v;
            return this;
        }

        public Builder kuromojiReadingform(Function<KuromojiReadingFormTokenFilter.Builder, ObjectBuilder<KuromojiReadingFormTokenFilter>> f) {
            return this.kuromojiReadingform(f.apply(new KuromojiReadingFormTokenFilter.Builder()).build());
        }

        public Builder kuromojiStemmer(KuromojiStemmerTokenFilter v) {
            this._type = TokenFilter.KUROMOJI_STEMMER;
            this._value = v;
            return this;
        }

        public Builder kuromojiStemmer(Function<KuromojiStemmerTokenFilter.Builder, ObjectBuilder<KuromojiStemmerTokenFilter>> f) {
            return this.kuromojiStemmer(f.apply(new KuromojiStemmerTokenFilter.Builder()).build());
        }

        public Builder length(LengthTokenFilter v) {
            this._type = TokenFilter.LENGTH;
            this._value = v;
            return this;
        }

        public Builder length(Function<LengthTokenFilter.Builder, ObjectBuilder<LengthTokenFilter>> f) {
            return this.length(f.apply(new LengthTokenFilter.Builder()).build());
        }

        public Builder limit(LimitTokenCountTokenFilter v) {
            this._type = TokenFilter.LIMIT;
            this._value = v;
            return this;
        }

        public Builder limit(Function<LimitTokenCountTokenFilter.Builder, ObjectBuilder<LimitTokenCountTokenFilter>> f) {
            return this.limit(f.apply(new LimitTokenCountTokenFilter.Builder()).build());
        }

        public Builder lowercase(LowercaseTokenFilter v) {
            this._type = TokenFilter.LOWERCASE;
            this._value = v;
            return this;
        }

        public Builder lowercase(Function<LowercaseTokenFilter.Builder, ObjectBuilder<LowercaseTokenFilter>> f) {
            return this.lowercase(f.apply(new LowercaseTokenFilter.Builder()).build());
        }

        public Builder multiplexer(MultiplexerTokenFilter v) {
            this._type = TokenFilter.MULTIPLEXER;
            this._value = v;
            return this;
        }

        public Builder multiplexer(Function<MultiplexerTokenFilter.Builder, ObjectBuilder<MultiplexerTokenFilter>> f) {
            return this.multiplexer(f.apply(new MultiplexerTokenFilter.Builder()).build());
        }

        public Builder ngram(NGramTokenFilter v) {
            this._type = TokenFilter.NGRAM;
            this._value = v;
            return this;
        }

        public Builder ngram(Function<NGramTokenFilter.Builder, ObjectBuilder<NGramTokenFilter>> f) {
            return this.ngram(f.apply(new NGramTokenFilter.Builder()).build());
        }

        public Builder noriPartOfSpeech(NoriPartOfSpeechTokenFilter v) {
            this._type = TokenFilter.NORI_PART_OF_SPEECH;
            this._value = v;
            return this;
        }

        public Builder noriPartOfSpeech(Function<NoriPartOfSpeechTokenFilter.Builder, ObjectBuilder<NoriPartOfSpeechTokenFilter>> f) {
            return this.noriPartOfSpeech(f.apply(new NoriPartOfSpeechTokenFilter.Builder()).build());
        }

        public Builder patternCapture(PatternCaptureTokenFilter v) {
            this._type = TokenFilter.PATTERN_CAPTURE;
            this._value = v;
            return this;
        }

        public Builder patternCapture(Function<PatternCaptureTokenFilter.Builder, ObjectBuilder<PatternCaptureTokenFilter>> f) {
            return this.patternCapture(f.apply(new PatternCaptureTokenFilter.Builder()).build());
        }

        public Builder patternReplace(PatternReplaceTokenFilter v) {
            this._type = TokenFilter.PATTERN_REPLACE;
            this._value = v;
            return this;
        }

        public Builder patternReplace(Function<PatternReplaceTokenFilter.Builder, ObjectBuilder<PatternReplaceTokenFilter>> f) {
            return this.patternReplace(f.apply(new PatternReplaceTokenFilter.Builder()).build());
        }

        public Builder porterStem(PorterStemTokenFilter v) {
            this._type = TokenFilter.PORTER_STEM;
            this._value = v;
            return this;
        }

        public Builder porterStem(Function<PorterStemTokenFilter.Builder, ObjectBuilder<PorterStemTokenFilter>> f) {
            return this.porterStem(f.apply(new PorterStemTokenFilter.Builder()).build());
        }

        public Builder predicateTokenFilter(PredicateTokenFilter v) {
            this._type = TokenFilter.PREDICATE_TOKEN_FILTER;
            this._value = v;
            return this;
        }

        public Builder predicateTokenFilter(Function<PredicateTokenFilter.Builder, ObjectBuilder<PredicateTokenFilter>> f) {
            return this.predicateTokenFilter(f.apply(new PredicateTokenFilter.Builder()).build());
        }

        public Builder removeDuplicates(RemoveDuplicatesTokenFilter v) {
            this._type = TokenFilter.REMOVE_DUPLICATES;
            this._value = v;
            return this;
        }

        public Builder removeDuplicates(Function<RemoveDuplicatesTokenFilter.Builder, ObjectBuilder<RemoveDuplicatesTokenFilter>> f) {
            return this.removeDuplicates(f.apply(new RemoveDuplicatesTokenFilter.Builder()).build());
        }

        public Builder reverse(ReverseTokenFilter v) {
            this._type = TokenFilter.REVERSE;
            this._value = v;
            return this;
        }

        public Builder reverse(Function<ReverseTokenFilter.Builder, ObjectBuilder<ReverseTokenFilter>> f) {
            return this.reverse(f.apply(new ReverseTokenFilter.Builder()).build());
        }

        public Builder shingle(ShingleTokenFilter v) {
            this._type = TokenFilter.SHINGLE;
            this._value = v;
            return this;
        }

        public Builder shingle(Function<ShingleTokenFilter.Builder, ObjectBuilder<ShingleTokenFilter>> f) {
            return this.shingle(f.apply(new ShingleTokenFilter.Builder()).build());
        }

        public Builder snowball(SnowballTokenFilter v) {
            this._type = TokenFilter.SNOWBALL;
            this._value = v;
            return this;
        }

        public Builder snowball(Function<SnowballTokenFilter.Builder, ObjectBuilder<SnowballTokenFilter>> f) {
            return this.snowball(f.apply(new SnowballTokenFilter.Builder()).build());
        }

        public Builder stemmerOverride(StemmerOverrideTokenFilter v) {
            this._type = TokenFilter.STEMMER_OVERRIDE;
            this._value = v;
            return this;
        }

        public Builder stemmerOverride(Function<StemmerOverrideTokenFilter.Builder, ObjectBuilder<StemmerOverrideTokenFilter>> f) {
            return this.stemmerOverride(f.apply(new StemmerOverrideTokenFilter.Builder()).build());
        }

        public Builder stemmer(StemmerTokenFilter v) {
            this._type = TokenFilter.STEMMER;
            this._value = v;
            return this;
        }

        public Builder stemmer(Function<StemmerTokenFilter.Builder, ObjectBuilder<StemmerTokenFilter>> f) {
            return this.stemmer(f.apply(new StemmerTokenFilter.Builder()).build());
        }

        public Builder stop(StopTokenFilter v) {
            this._type = TokenFilter.STOP;
            this._value = v;
            return this;
        }

        public Builder stop(Function<StopTokenFilter.Builder, ObjectBuilder<StopTokenFilter>> f) {
            return this.stop(f.apply(new StopTokenFilter.Builder()).build());
        }

        public Builder synonymGraph(SynonymGraphTokenFilter v) {
            this._type = TokenFilter.SYNONYM_GRAPH;
            this._value = v;
            return this;
        }

        public Builder synonymGraph(Function<SynonymGraphTokenFilter.Builder, ObjectBuilder<SynonymGraphTokenFilter>> f) {
            return this.synonymGraph(f.apply(new SynonymGraphTokenFilter.Builder()).build());
        }

        public Builder synonym(SynonymTokenFilter v) {
            this._type = TokenFilter.SYNONYM;
            this._value = v;
            return this;
        }

        public Builder synonym(Function<SynonymTokenFilter.Builder, ObjectBuilder<SynonymTokenFilter>> f) {
            return this.synonym(f.apply(new SynonymTokenFilter.Builder()).build());
        }

        public Builder trim(TrimTokenFilter v) {
            this._type = TokenFilter.TRIM;
            this._value = v;
            return this;
        }

        public Builder trim(Function<TrimTokenFilter.Builder, ObjectBuilder<TrimTokenFilter>> f) {
            return this.trim(f.apply(new TrimTokenFilter.Builder()).build());
        }

        public Builder truncate(TruncateTokenFilter v) {
            this._type = TokenFilter.TRUNCATE;
            this._value = v;
            return this;
        }

        public Builder truncate(Function<TruncateTokenFilter.Builder, ObjectBuilder<TruncateTokenFilter>> f) {
            return this.truncate(f.apply(new TruncateTokenFilter.Builder()).build());
        }

        public Builder unique(UniqueTokenFilter v) {
            this._type = TokenFilter.UNIQUE;
            this._value = v;
            return this;
        }

        public Builder unique(Function<UniqueTokenFilter.Builder, ObjectBuilder<UniqueTokenFilter>> f) {
            return this.unique(f.apply(new UniqueTokenFilter.Builder()).build());
        }

        public Builder uppercase(UppercaseTokenFilter v) {
            this._type = TokenFilter.UPPERCASE;
            this._value = v;
            return this;
        }

        public Builder uppercase(Function<UppercaseTokenFilter.Builder, ObjectBuilder<UppercaseTokenFilter>> f) {
            return this.uppercase(f.apply(new UppercaseTokenFilter.Builder()).build());
        }

        public Builder wordDelimiterGraph(WordDelimiterGraphTokenFilter v) {
            this._type = TokenFilter.WORD_DELIMITER_GRAPH;
            this._value = v;
            return this;
        }

        public Builder wordDelimiterGraph(Function<WordDelimiterGraphTokenFilter.Builder, ObjectBuilder<WordDelimiterGraphTokenFilter>> f) {
            return this.wordDelimiterGraph(f.apply(new WordDelimiterGraphTokenFilter.Builder()).build());
        }

        public Builder wordDelimiter(WordDelimiterTokenFilter v) {
            this._type = TokenFilter.WORD_DELIMITER;
            this._value = v;
            return this;
        }

        public Builder wordDelimiter(Function<WordDelimiterTokenFilter.Builder, ObjectBuilder<WordDelimiterTokenFilter>> f) {
            return this.wordDelimiter(f.apply(new WordDelimiterTokenFilter.Builder()).build());
        }

        @Override
        public TokenFilter build() {
            return new TokenFilter(this);
        }
    }
}

