/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StandardAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final int maxTokenLength;
    private final List<String> stopwords;
    public static final JsonpDeserializer<StandardAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardAnalyzer::setupStandardAnalyzerDeserializer, Builder::build);

    public StandardAnalyzer(Builder builder) {
        this.maxTokenLength = Objects.requireNonNull(builder.maxTokenLength, "max_token_length");
        this.stopwords = ModelTypeHelper.unmodifiableNonNull(builder.stopwords, "stopwords");
    }

    public StandardAnalyzer(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "standard";
    }

    public int maxTokenLength() {
        return this.maxTokenLength;
    }

    public List<String> stopwords() {
        return this.stopwords;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "standard");
        generator.writeKey("max_token_length");
        generator.write(this.maxTokenLength);
        generator.writeKey("stopwords");
        generator.writeStartArray();
        for (String item0 : this.stopwords) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupStandardAnalyzerDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxTokenLength, JsonpDeserializer.integerDeserializer(), "max_token_length", new String[0]);
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    implements ObjectBuilder<StandardAnalyzer> {
        private Integer maxTokenLength;
        private List<String> stopwords;

        public Builder maxTokenLength(int value) {
            this.maxTokenLength = value;
            return this;
        }

        public Builder stopwords(List<String> value) {
            this.stopwords = value;
            return this;
        }

        public Builder stopwords(String ... value) {
            this.stopwords = Arrays.asList(value);
            return this;
        }

        public Builder addStopwords(String value) {
            if (this.stopwords == null) {
                this.stopwords = new ArrayList<String>();
            }
            this.stopwords.add(value);
            return this;
        }

        @Override
        public StandardAnalyzer build() {
            return new StandardAnalyzer(this);
        }
    }
}

