/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LimitTokenCountTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final boolean consumeAllTokens;
    private final int maxTokenCount;
    public static final JsonpDeserializer<LimitTokenCountTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LimitTokenCountTokenFilter::setupLimitTokenCountTokenFilterDeserializer, Builder::build);

    public LimitTokenCountTokenFilter(Builder builder) {
        super(builder);
        this.consumeAllTokens = Objects.requireNonNull(builder.consumeAllTokens, "consume_all_tokens");
        this.maxTokenCount = Objects.requireNonNull(builder.maxTokenCount, "max_token_count");
    }

    public LimitTokenCountTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "limit";
    }

    public boolean consumeAllTokens() {
        return this.consumeAllTokens;
    }

    public int maxTokenCount() {
        return this.maxTokenCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "limit");
        super.serializeInternal(generator, mapper);
        generator.writeKey("consume_all_tokens");
        generator.write(this.consumeAllTokens);
        generator.writeKey("max_token_count");
        generator.write(this.maxTokenCount);
    }

    protected static void setupLimitTokenCountTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::consumeAllTokens, JsonpDeserializer.booleanDeserializer(), "consume_all_tokens", new String[0]);
        op.add(Builder::maxTokenCount, JsonpDeserializer.integerDeserializer(), "max_token_count", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LimitTokenCountTokenFilter> {
        private Boolean consumeAllTokens;
        private Integer maxTokenCount;

        public Builder consumeAllTokens(boolean value) {
            this.consumeAllTokens = value;
            return this;
        }

        public Builder maxTokenCount(int value) {
            this.maxTokenCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LimitTokenCountTokenFilter build() {
            return new LimitTokenCountTokenFilter(this);
        }
    }
}

