/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LengthTokenFilter
extends TokenFilterBase
implements TokenFilterVariant {
    private final int max;
    private final int min;
    public static final JsonpDeserializer<LengthTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LengthTokenFilter::setupLengthTokenFilterDeserializer, Builder::build);

    public LengthTokenFilter(Builder builder) {
        super(builder);
        this.max = Objects.requireNonNull(builder.max, "max");
        this.min = Objects.requireNonNull(builder.min, "min");
    }

    public LengthTokenFilter(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "length";
    }

    public int max() {
        return this.max;
    }

    public int min() {
        return this.min;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "length");
        super.serializeInternal(generator, mapper);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("min");
        generator.write(this.min);
    }

    protected static void setupLengthTokenFilterDeserializer(DelegatingDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::max, JsonpDeserializer.integerDeserializer(), "max", new String[0]);
        op.add(Builder::min, JsonpDeserializer.integerDeserializer(), "min", new String[0]);
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<LengthTokenFilter> {
        private Integer max;
        private Integer min;

        public Builder max(int value) {
            this.max = value;
            return this;
        }

        public Builder min(int value) {
            this.min = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LengthTokenFilter build() {
            return new LengthTokenFilter(this);
        }
    }
}

