/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.ValueType;
import co.elastic.clients.elasticsearch._types.aggregations.WeightedAverageValue;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WeightedAverageAggregation
extends AggregationBase
implements AggregationVariant {
    @Nullable
    private final String format;
    @Nullable
    private final WeightedAverageValue value;
    @Nullable
    private final ValueType valueType;
    @Nullable
    private final WeightedAverageValue weight;
    public static final JsonpDeserializer<WeightedAverageAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageAggregation::setupWeightedAverageAggregationDeserializer, Builder::build);

    public WeightedAverageAggregation(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.value = builder.value;
        this.valueType = builder.valueType;
        this.weight = builder.weight;
    }

    public WeightedAverageAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "weighted_avg";
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public WeightedAverageValue value() {
        return this.value;
    }

    @Nullable
    public ValueType valueType() {
        return this.valueType;
    }

    @Nullable
    public WeightedAverageValue weight() {
        return this.weight;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            this.weight.serialize(generator, mapper);
        }
    }

    protected static void setupWeightedAverageAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format", new String[0]);
        op.add(Builder::value, WeightedAverageValue._DESERIALIZER, "value", new String[0]);
        op.add(Builder::valueType, ValueType._DESERIALIZER, "value_type", new String[0]);
        op.add(Builder::weight, WeightedAverageValue._DESERIALIZER, "weight", new String[0]);
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WeightedAverageAggregation> {
        @Nullable
        private String format;
        @Nullable
        private WeightedAverageValue value;
        @Nullable
        private ValueType valueType;
        @Nullable
        private WeightedAverageValue weight;

        public Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder value(@Nullable WeightedAverageValue value) {
            this.value = value;
            return this;
        }

        public Builder value(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.value(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        public Builder valueType(@Nullable ValueType value) {
            this.valueType = value;
            return this;
        }

        public Builder weight(@Nullable WeightedAverageValue value) {
            this.weight = value;
            return this;
        }

        public Builder weight(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.weight(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WeightedAverageAggregation build() {
            return new WeightedAverageAggregation(this);
        }
    }
}

