/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AdjacencyMatrixAggregation
extends BucketAggregationBase
implements AggregationVariant {
    @Nullable
    private final Map<String, Query> filters;
    public static final JsonpDeserializer<AdjacencyMatrixAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdjacencyMatrixAggregation::setupAdjacencyMatrixAggregationDeserializer, Builder::build);

    public AdjacencyMatrixAggregation(Builder builder) {
        super(builder);
        this.filters = ModelTypeHelper.unmodifiable(builder.filters);
    }

    public AdjacencyMatrixAggregation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "adjacency_matrix";
    }

    @Nullable
    public Map<String, Query> filters() {
        return this.filters;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.filters != null) {
            generator.writeKey("filters");
            generator.writeStartObject();
            for (Map.Entry<String, Query> item0 : this.filters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAdjacencyMatrixAggregationDeserializer(DelegatingDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.stringMapDeserializer(Query._DESERIALIZER), "filters", new String[0]);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AdjacencyMatrixAggregation> {
        @Nullable
        private Map<String, Query> filters;

        public Builder filters(@Nullable Map<String, Query> value) {
            this.filters = value;
            return this;
        }

        public Builder putFilters(String key, Query value) {
            if (this.filters == null) {
                this.filters = new HashMap<String, Query>();
            }
            this.filters.put(key, value);
            return this;
        }

        public Builder filters(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filters(Collections.singletonMap(key, fn.apply(new Query.Builder()).build()));
        }

        public Builder putFilters(String key, Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.putFilters(key, fn.apply(new Query.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdjacencyMatrixAggregation build() {
            return new AdjacencyMatrixAggregation(this);
        }
    }
}

