/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ElasticsearchVersionInfo
implements JsonpSerializable {
    private final String buildDate;
    private final String buildFlavor;
    private final String buildHash;
    private final boolean buildSnapshot;
    private final String buildType;
    private final String luceneVersion;
    private final String minimumIndexCompatibilityVersion;
    private final String minimumWireCompatibilityVersion;
    private final String number;
    public static final JsonpDeserializer<ElasticsearchVersionInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElasticsearchVersionInfo::setupElasticsearchVersionInfoDeserializer, Builder::build);

    public ElasticsearchVersionInfo(Builder builder) {
        this.buildDate = Objects.requireNonNull(builder.buildDate, "build_date");
        this.buildFlavor = Objects.requireNonNull(builder.buildFlavor, "build_flavor");
        this.buildHash = Objects.requireNonNull(builder.buildHash, "build_hash");
        this.buildSnapshot = Objects.requireNonNull(builder.buildSnapshot, "build_snapshot");
        this.buildType = Objects.requireNonNull(builder.buildType, "build_type");
        this.luceneVersion = Objects.requireNonNull(builder.luceneVersion, "lucene_version");
        this.minimumIndexCompatibilityVersion = Objects.requireNonNull(builder.minimumIndexCompatibilityVersion, "minimum_index_compatibility_version");
        this.minimumWireCompatibilityVersion = Objects.requireNonNull(builder.minimumWireCompatibilityVersion, "minimum_wire_compatibility_version");
        this.number = Objects.requireNonNull(builder.number, "number");
    }

    public ElasticsearchVersionInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String buildDate() {
        return this.buildDate;
    }

    public String buildFlavor() {
        return this.buildFlavor;
    }

    public String buildHash() {
        return this.buildHash;
    }

    public boolean buildSnapshot() {
        return this.buildSnapshot;
    }

    public String buildType() {
        return this.buildType;
    }

    public String luceneVersion() {
        return this.luceneVersion;
    }

    public String minimumIndexCompatibilityVersion() {
        return this.minimumIndexCompatibilityVersion;
    }

    public String minimumWireCompatibilityVersion() {
        return this.minimumWireCompatibilityVersion;
    }

    public String number() {
        return this.number;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_date");
        generator.write(this.buildDate);
        generator.writeKey("build_flavor");
        generator.write(this.buildFlavor);
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("build_snapshot");
        generator.write(this.buildSnapshot);
        generator.writeKey("build_type");
        generator.write(this.buildType);
        generator.writeKey("lucene_version");
        generator.write(this.luceneVersion);
        generator.writeKey("minimum_index_compatibility_version");
        generator.write(this.minimumIndexCompatibilityVersion);
        generator.writeKey("minimum_wire_compatibility_version");
        generator.write(this.minimumWireCompatibilityVersion);
        generator.writeKey("number");
        generator.write(this.number);
    }

    protected static void setupElasticsearchVersionInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::buildDate, JsonpDeserializer.stringDeserializer(), "build_date", new String[0]);
        op.add(Builder::buildFlavor, JsonpDeserializer.stringDeserializer(), "build_flavor", new String[0]);
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash", new String[0]);
        op.add(Builder::buildSnapshot, JsonpDeserializer.booleanDeserializer(), "build_snapshot", new String[0]);
        op.add(Builder::buildType, JsonpDeserializer.stringDeserializer(), "build_type", new String[0]);
        op.add(Builder::luceneVersion, JsonpDeserializer.stringDeserializer(), "lucene_version", new String[0]);
        op.add(Builder::minimumIndexCompatibilityVersion, JsonpDeserializer.stringDeserializer(), "minimum_index_compatibility_version", new String[0]);
        op.add(Builder::minimumWireCompatibilityVersion, JsonpDeserializer.stringDeserializer(), "minimum_wire_compatibility_version", new String[0]);
        op.add(Builder::number, JsonpDeserializer.stringDeserializer(), "number", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ElasticsearchVersionInfo> {
        private String buildDate;
        private String buildFlavor;
        private String buildHash;
        private Boolean buildSnapshot;
        private String buildType;
        private String luceneVersion;
        private String minimumIndexCompatibilityVersion;
        private String minimumWireCompatibilityVersion;
        private String number;

        public Builder buildDate(String value) {
            this.buildDate = value;
            return this;
        }

        public Builder buildFlavor(String value) {
            this.buildFlavor = value;
            return this;
        }

        public Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        public Builder buildSnapshot(boolean value) {
            this.buildSnapshot = value;
            return this;
        }

        public Builder buildType(String value) {
            this.buildType = value;
            return this;
        }

        public Builder luceneVersion(String value) {
            this.luceneVersion = value;
            return this;
        }

        public Builder minimumIndexCompatibilityVersion(String value) {
            this.minimumIndexCompatibilityVersion = value;
            return this;
        }

        public Builder minimumWireCompatibilityVersion(String value) {
            this.minimumWireCompatibilityVersion = value;
            return this;
        }

        public Builder number(String value) {
            this.number = value;
            return this;
        }

        @Override
        public ElasticsearchVersionInfo build() {
            return new ElasticsearchVersionInfo(this);
        }
    }
}

