/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class ChainTransform
implements TransformVariant,
JsonpSerializable {
    private final List<Transform> transforms;
    public static final JsonpDeserializer<ChainTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChainTransform::setupChainTransformDeserializer, Builder::build);

    public ChainTransform(Builder builder) {
        this.transforms = ModelTypeHelper.unmodifiableNonNull(builder.transforms, "transforms");
    }

    public ChainTransform(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "chain";
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("transforms");
        generator.writeStartArray();
        for (Transform item0 : this.transforms) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupChainTransformDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::transforms, JsonpDeserializer.arrayDeserializer(Transform._DESERIALIZER), "transforms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ChainTransform> {
        private List<Transform> transforms;

        public Builder transforms(List<Transform> value) {
            this.transforms = value;
            return this;
        }

        public Builder transforms(Transform ... value) {
            this.transforms = Arrays.asList(value);
            return this;
        }

        public Builder addTransforms(Transform value) {
            if (this.transforms == null) {
                this.transforms = new ArrayList<Transform>();
            }
            this.transforms.add(value);
            return this;
        }

        public Builder transforms(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transforms(fn.apply(new Transform.Builder()).build());
        }

        public Builder addTransforms(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.addTransforms(fn.apply(new Transform.Builder()).build());
        }

        @Override
        public ChainTransform build() {
            return new ChainTransform(this);
        }
    }
}

