/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._core.get_script_languages;

import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LanguageContext
implements JsonpSerializable {
    private final List<String> contexts;
    private final ScriptLanguage language;
    public static final JsonpDeserializer<LanguageContext> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LanguageContext::setupLanguageContextDeserializer, Builder::build);

    public LanguageContext(Builder builder) {
        this.contexts = ModelTypeHelper.unmodifiableNonNull(builder.contexts, "contexts");
        this.language = Objects.requireNonNull(builder.language, "language");
    }

    public LanguageContext(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> contexts() {
        return this.contexts;
    }

    public ScriptLanguage language() {
        return this.language;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("contexts");
        generator.writeStartArray();
        for (String item0 : this.contexts) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
    }

    protected static void setupLanguageContextDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::contexts, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "contexts", new String[0]);
        op.add(Builder::language, ScriptLanguage._DESERIALIZER, "language", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<LanguageContext> {
        private List<String> contexts;
        private ScriptLanguage language;

        public Builder contexts(List<String> value) {
            this.contexts = value;
            return this;
        }

        public Builder contexts(String ... value) {
            this.contexts = Arrays.asList(value);
            return this;
        }

        public Builder addContexts(String value) {
            if (this.contexts == null) {
                this.contexts = new ArrayList<String>();
            }
            this.contexts.add(value);
            return this;
        }

        public Builder language(ScriptLanguage value) {
            this.language = value;
            return this;
        }

        @Override
        public LanguageContext build() {
            return new LanguageContext(this);
        }
    }
}

