/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.base;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.json.JsonpDeserializer;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.client.utils.URLEncodedUtils;

public class SimpleEndpoint<RequestT, ResponseT>
implements Endpoint<RequestT, ResponseT, ElasticsearchError> {
    private static final Function<?, Map<String, String>> EMPTY_MAP = x -> Collections.emptyMap();
    private final Function<RequestT, String> method;
    private final Function<RequestT, String> requestUrl;
    private final Function<RequestT, Map<String, String>> queryParameters;
    private final Function<RequestT, Map<String, String>> headers;
    private final boolean hasRequestBody;
    private final JsonpDeserializer<ResponseT> responseParser;

    public static <T> Function<T, Map<String, String>> emptyMap() {
        return EMPTY_MAP;
    }

    public SimpleEndpoint(Function<RequestT, String> method, Function<RequestT, String> requestUrl, Function<RequestT, Map<String, String>> queryParameters, Function<RequestT, Map<String, String>> headers, boolean hasRequestBody, JsonpDeserializer<ResponseT> responseParser) {
        this.method = method;
        this.requestUrl = requestUrl;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.hasRequestBody = hasRequestBody;
        this.responseParser = responseParser;
    }

    @Override
    public String method(RequestT request) {
        return this.method.apply(request);
    }

    @Override
    public String requestUrl(RequestT request) {
        return this.requestUrl.apply(request);
    }

    @Override
    public Map<String, String> queryParameters(RequestT request) {
        return this.queryParameters.apply(request);
    }

    @Override
    public Map<String, String> headers(RequestT request) {
        return this.headers.apply(request);
    }

    @Override
    public boolean hasRequestBody() {
        return this.hasRequestBody;
    }

    @Override
    public JsonpDeserializer<ResponseT> responseParser() {
        return this.responseParser;
    }

    @Override
    public boolean isError(int statusCode) {
        return statusCode >= 400;
    }

    @Override
    public JsonpDeserializer<ElasticsearchError> errorParser(int statusCode) {
        return ElasticsearchError._DESERIALIZER;
    }

    public <NewResponseT> SimpleEndpoint<RequestT, NewResponseT> withResponseDeserializer(JsonpDeserializer<NewResponseT> newResponseParser) {
        return new SimpleEndpoint<RequestT, NewResponseT>(this.method, this.requestUrl, this.queryParameters, this.headers, this.hasRequestBody, newResponseParser);
    }

    public static RuntimeException noPathTemplateFound(String what) {
        return new RuntimeException("Could not find a request " + what + " with this set of properties. Please check the API documentation, or raise an issue if this should be a valid request.");
    }

    public static void pathEncode(String src, StringBuilder dest) {
        dest.append(URLEncodedUtils.formatSegments((String[])new String[]{src}).substring(1));
    }
}

