/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.util;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.StringEnum;
import co.elastic.clients.util.TaggedUnion2;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.function.BiFunction;

public class TaggedUnionParsers {
    public static <T extends Enum<T>, V, TU extends TaggedUnion2<T, V>> JsonpDeserializer<TU> externallyTagged(BiFunction<T, V, TU> unionCtor, EnumMap<T, JsonpDeserializer<? extends V>> variantParsers, StringEnum.Deserializer<T> tagParser) {
        return JsonpDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT), (parser, params, event) -> {
            JsonpUtils.expectNextEvent(parser, JsonParser.Event.KEY_NAME);
            String tagValue = parser.getString();
            Object tag = tagParser.deserialize(tagValue, (JsonParser)parser);
            JsonpDeserializer variantParser = (JsonpDeserializer)variantParsers.get(tag);
            if (variantParser == null) {
                throw new JsonParsingException("No parser for variant '" + ((StringEnum)tag).jsonValue() + "'", parser.getLocation());
            }
            Object value = variantParser.deserialize((JsonParser)parser, (JsonpMapper)params);
            JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
            return (TaggedUnion2)unionCtor.apply(tag, value);
        });
    }

    public static <T extends Enum<T>, V, TU extends TaggedUnion2<T, V>> JsonpDeserializer<TU> internallyTagged(String tagField, BiFunction<T, V, TU> unionCtor, EnumMap<T, JsonpDeserializer<? extends V>> variantParsers, StringEnum.Deserializer<T> tagParser) {
        return JsonpDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT), (parser, params, event) -> {
            JsonObject object = parser.getObject();
            String tagValue = object.getString(tagField);
            Object tag = tagParser.deserialize(tagValue, (JsonParser)parser);
            JsonpDeserializer variantParser = (JsonpDeserializer)variantParsers.get(tag);
            if (variantParser == null) {
                throw new JsonParsingException("No parser for variant '" + ((StringEnum)tag).jsonValue() + "'", parser.getLocation());
            }
            JsonParser objectParser = params.jsonProvider().createParserFactory(null).createParser(object);
            Object value = variantParser.deserialize(objectParser, (JsonpMapper)params);
            return (TaggedUnion2)unionCtor.apply(tag, value);
        });
    }

    public static <T extends Enum<T>, V, TU extends TaggedUnion2<T, V>> JsonpDeserializer<TU> externallyTagged(BiFunction<T, V, TU> unionCtor, EnumMap<T, JsonpDeserializer<? extends V>> variantParsers, StringEnum.Deserializer<T> tagParser, String tagValue) {
        return JsonpDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT), (parser, params, event) -> {
            Object tag = tagParser.deserialize(tagValue, (JsonParser)parser);
            JsonpDeserializer variantParser = (JsonpDeserializer)variantParsers.get(tag);
            if (variantParser == null) {
                throw new JsonParsingException("No parser for variant '" + ((StringEnum)tag).jsonValue() + "'", parser.getLocation());
            }
            Object value = variantParser.deserialize((JsonParser)parser, (JsonpMapper)params);
            return (TaggedUnion2)unionCtor.apply(tag, value);
        });
    }
}

