/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RealmCache
implements JsonpSerializable {
    private final long size;
    public static final JsonpDeserializer<RealmCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RealmCache::setupRealmCacheDeserializer, Builder::build);

    public RealmCache(Builder builder) {
        this.size = Objects.requireNonNull(builder.size, "size");
    }

    public RealmCache(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("size");
        generator.write(this.size);
    }

    protected static void setupRealmCacheDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RealmCache> {
        private Long size;

        public Builder size(long value) {
            this.size = value;
            return this;
        }

        @Override
        public RealmCache build() {
            return new RealmCache(this);
        }
    }
}

