/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Flattened
extends Base {
    private final int fieldCount;
    public static final JsonpDeserializer<Flattened> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Flattened::setupFlattenedDeserializer, Builder::build);

    public Flattened(Builder builder) {
        super(builder);
        this.fieldCount = Objects.requireNonNull(builder.fieldCount, "field_count");
    }

    public Flattened(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int fieldCount() {
        return this.fieldCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field_count");
        generator.write(this.fieldCount);
    }

    protected static void setupFlattenedDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::fieldCount, JsonpDeserializer.integerDeserializer(), "field_count", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Flattened> {
        private Integer fieldCount;

        public Builder fieldCount(int value) {
            this.fieldCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Flattened build() {
            return new Flattened(this);
        }
    }
}

