/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.AnalyticsStatistics;
import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Analytics
extends Base {
    private final AnalyticsStatistics stats;
    public static final JsonpDeserializer<Analytics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Analytics::setupAnalyticsDeserializer, Builder::build);

    public Analytics(Builder builder) {
        super(builder);
        this.stats = Objects.requireNonNull(builder.stats, "stats");
    }

    public Analytics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AnalyticsStatistics stats() {
        return this.stats;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    protected static void setupAnalyticsDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::stats, AnalyticsStatistics._DESERIALIZER, "stats", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Analytics> {
        private AnalyticsStatistics stats;

        public Builder stats(AnalyticsStatistics value) {
            this.stats = value;
            return this;
        }

        public Builder stats(Function<AnalyticsStatistics.Builder, ObjectBuilder<AnalyticsStatistics>> fn) {
            return this.stats(fn.apply(new AnalyticsStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Analytics build() {
            return new Analytics(this);
        }
    }
}

