/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.xpack.InfoResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class InfoRequest
extends RequestBase {
    @Nullable
    private final List<String> categories;
    public static final Endpoint<InfoRequest, InfoResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<InfoRequest, InfoResponse>(request -> "GET", request -> "/_xpack", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.categories != null) {
            params.put("categories", request.categories.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, InfoResponse._DESERIALIZER);

    public InfoRequest(Builder builder) {
        this.categories = ModelTypeHelper.unmodifiable(builder.categories);
    }

    public InfoRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> categories() {
        return this.categories;
    }

    public static class Builder
    implements ObjectBuilder<InfoRequest> {
        @Nullable
        private List<String> categories;

        public Builder categories(@Nullable List<String> value) {
            this.categories = value;
            return this;
        }

        public Builder categories(String ... value) {
            this.categories = Arrays.asList(value);
            return this;
        }

        public Builder addCategories(String value) {
            if (this.categories == null) {
                this.categories = new ArrayList<String>();
            }
            this.categories.add(value);
            return this;
        }

        @Override
        public InfoRequest build() {
            return new InfoRequest(this);
        }
    }
}

