/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class TimeOfMonth
implements JsonpSerializable {
    private final List<String> at;
    private final List<Integer> on;
    public static final JsonpDeserializer<TimeOfMonth> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeOfMonth::setupTimeOfMonthDeserializer, Builder::build);

    public TimeOfMonth(Builder builder) {
        this.at = ModelTypeHelper.unmodifiableNonNull(builder.at, "at");
        this.on = ModelTypeHelper.unmodifiableNonNull(builder.on, "on");
    }

    public TimeOfMonth(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> at() {
        return this.at;
    }

    public List<Integer> on() {
        return this.on;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("at");
        generator.writeStartArray();
        for (String string : this.at) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("on");
        generator.writeStartArray();
        for (Integer n : this.on) {
            generator.write(n.intValue());
        }
        generator.writeEnd();
    }

    protected static void setupTimeOfMonthDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::at, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "at", new String[0]);
        op.add(Builder::on, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "on", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TimeOfMonth> {
        private List<String> at;
        private List<Integer> on;

        public Builder at(List<String> value) {
            this.at = value;
            return this;
        }

        public Builder at(String ... value) {
            this.at = Arrays.asList(value);
            return this;
        }

        public Builder addAt(String value) {
            if (this.at == null) {
                this.at = new ArrayList<String>();
            }
            this.at.add(value);
            return this;
        }

        public Builder on(List<Integer> value) {
            this.on = value;
            return this;
        }

        public Builder on(Integer ... value) {
            this.on = Arrays.asList(value);
            return this;
        }

        public Builder addOn(Integer value) {
            if (this.on == null) {
                this.on = new ArrayList<Integer>();
            }
            this.on.add(value);
            return this;
        }

        @Override
        public TimeOfMonth build() {
            return new TimeOfMonth(this);
        }
    }
}

