/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.DailySchedule;
import co.elastic.clients.elasticsearch.watcher.HourlySchedule;
import co.elastic.clients.elasticsearch.watcher.ScheduleVariant;
import co.elastic.clients.elasticsearch.watcher.TimeOfMonth;
import co.elastic.clients.elasticsearch.watcher.TimeOfWeek;
import co.elastic.clients.elasticsearch.watcher.TimeOfYear;
import co.elastic.clients.elasticsearch.watcher.TriggerVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Schedule
implements TaggedUnion<Object>,
TriggerVariant,
JsonpSerializable {
    public static final String CRON = "cron";
    public static final String DAILY = "daily";
    public static final String HOURLY = "hourly";
    public static final String INTERVAL = "interval";
    public static final String MONTHLY = "monthly";
    public static final String WEEKLY = "weekly";
    public static final String YEARLY = "yearly";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Schedule> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Schedule::setupScheduleDeserializer, Builder::build);

    @Override
    public String _variantType() {
        return "schedule";
    }

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Schedule(ScheduleVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Schedule(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Schedule(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String cron() {
        return (String)TaggedUnionUtils.get(this, CRON);
    }

    public DailySchedule daily() {
        return (DailySchedule)TaggedUnionUtils.get(this, DAILY);
    }

    public HourlySchedule hourly() {
        return (HourlySchedule)TaggedUnionUtils.get(this, HOURLY);
    }

    public String interval() {
        return (String)TaggedUnionUtils.get(this, INTERVAL);
    }

    public List<TimeOfMonth> monthly() {
        return (List)TaggedUnionUtils.get(this, MONTHLY);
    }

    public List<TimeOfWeek> weekly() {
        return (List)TaggedUnionUtils.get(this, WEEKLY);
    }

    public List<TimeOfYear> yearly() {
        return (List)TaggedUnionUtils.get(this, YEARLY);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._type) {
                case "cron": {
                    generator.write((String)this._value);
                    break;
                }
                case "interval": {
                    generator.write((String)this._value);
                    break;
                }
                case "monthly": {
                    generator.writeStartArray();
                    for (TimeOfMonth item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case "weekly": {
                    generator.writeStartArray();
                    for (TimeOfWeek item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                    break;
                }
                case "yearly": {
                    generator.writeStartArray();
                    for (TimeOfYear item0 : (List)this._value) {
                        item0.serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    protected static void setupScheduleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), CRON, new String[0]);
        op.add(Builder::daily, DailySchedule._DESERIALIZER, DAILY, new String[0]);
        op.add(Builder::hourly, HourlySchedule._DESERIALIZER, HOURLY, new String[0]);
        op.add(Builder::interval, JsonpDeserializer.stringDeserializer(), INTERVAL, new String[0]);
        op.add(Builder::monthly, JsonpDeserializer.arrayDeserializer(TimeOfMonth._DESERIALIZER), MONTHLY, new String[0]);
        op.add(Builder::weekly, JsonpDeserializer.arrayDeserializer(TimeOfWeek._DESERIALIZER), WEEKLY, new String[0]);
        op.add(Builder::yearly, JsonpDeserializer.arrayDeserializer(TimeOfYear._DESERIALIZER), YEARLY, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Schedule> {
        private String _type;
        private Object _value;

        public Builder cron(String v) {
            this._type = Schedule.CRON;
            this._value = v;
            return this;
        }

        public Builder daily(DailySchedule v) {
            this._type = Schedule.DAILY;
            this._value = v;
            return this;
        }

        public Builder daily(Function<DailySchedule.Builder, ObjectBuilder<DailySchedule>> f) {
            return this.daily(f.apply(new DailySchedule.Builder()).build());
        }

        public Builder hourly(HourlySchedule v) {
            this._type = Schedule.HOURLY;
            this._value = v;
            return this;
        }

        public Builder hourly(Function<HourlySchedule.Builder, ObjectBuilder<HourlySchedule>> f) {
            return this.hourly(f.apply(new HourlySchedule.Builder()).build());
        }

        public Builder interval(String v) {
            this._type = Schedule.INTERVAL;
            this._value = v;
            return this;
        }

        public Builder monthly(List<TimeOfMonth> v) {
            this._type = Schedule.MONTHLY;
            this._value = v;
            return this;
        }

        public Builder weekly(List<TimeOfWeek> v) {
            this._type = Schedule.WEEKLY;
            this._value = v;
            return this;
        }

        public Builder yearly(List<TimeOfYear> v) {
            this._type = Schedule.YEARLY;
            this._value = v;
            return this;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }
    }
}

