/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.SyncVariant;
import co.elastic.clients.elasticsearch.transform.TimeSync;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public class Sync
implements TaggedUnion<Object>,
JsonpSerializable {
    public static final String TIME = "time";
    private final String _type;
    private final Object _value;
    public static final JsonpDeserializer<Sync> _DESERIALIZER = JsonpDeserializer.lazy(Builder::new, Sync::setupSyncDeserializer, Builder::build);

    @Override
    public String _type() {
        return this._type;
    }

    @Override
    public Object _get() {
        return this._value;
    }

    public Sync(SyncVariant value) {
        this._type = Objects.requireNonNull(value._variantType(), "variant type");
        this._value = Objects.requireNonNull(value, "variant value");
    }

    private Sync(Builder builder) {
        this._type = Objects.requireNonNull(builder._type, "variant type");
        this._value = Objects.requireNonNull(builder._value, "variant value");
    }

    public Sync(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public TimeSync time() {
        return (TimeSync)TaggedUnionUtils.get(this, TIME);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._type);
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSyncDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::time, TimeSync._DESERIALIZER, TIME, new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Sync> {
        private String _type;
        private Object _value;

        public Builder time(TimeSync v) {
            this._type = Sync.TIME;
            this._value = v;
            return this;
        }

        public Builder time(Function<TimeSync.Builder, ObjectBuilder<TimeSync>> f) {
            return this.time(f.apply(new TimeSync.Builder()).build());
        }

        @Override
        public Sync build() {
            return new Sync(this);
        }
    }
}

