/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.sql;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.sql.TranslateResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TranslateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final Query filter;
    private final String query;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<TranslateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TranslateRequest::setupTranslateRequestDeserializer, Builder::build);
    public static final Endpoint<TranslateRequest, TranslateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<TranslateRequest, TranslateResponse>(request -> "POST", request -> "/_sql/translate", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, TranslateResponse._DESERIALIZER);

    public TranslateRequest(Builder builder) {
        this.fetchSize = builder.fetchSize;
        this.filter = builder.filter;
        this.query = Objects.requireNonNull(builder.query, "query");
        this.timeZone = builder.timeZone;
    }

    public TranslateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer fetchSize() {
        return this.fetchSize;
    }

    @Nullable
    public Query filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    @Nullable
    public String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fetchSize != null) {
            generator.writeKey("fetch_size");
            generator.write(this.fetchSize.intValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupTranslateRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fetchSize, JsonpDeserializer.integerDeserializer(), "fetch_size", new String[0]);
        op.add(Builder::filter, Query._DESERIALIZER, "filter", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TranslateRequest> {
        @Nullable
        private Integer fetchSize;
        @Nullable
        private Query filter;
        private String query;
        @Nullable
        private String timeZone;

        public Builder fetchSize(@Nullable Integer value) {
            this.fetchSize = value;
            return this;
        }

        public Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public Builder query(String value) {
            this.query = value;
            return this;
        }

        public Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        public TranslateRequest build() {
            return new TranslateRequest(this);
        }
    }
}

