/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.SnapshotInfo;
import co.elastic.clients.elasticsearch.snapshot.get.SnapshotResponseItem;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetResponse
implements JsonpSerializable {
    @Nullable
    private final List<SnapshotResponseItem> responses;
    @Nullable
    private final List<SnapshotInfo> snapshots;
    private final int total;
    private final int remaining;
    public static final JsonpDeserializer<GetResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetResponse::setupGetResponseDeserializer, Builder::build);

    public GetResponse(Builder builder) {
        this.responses = ModelTypeHelper.unmodifiable(builder.responses);
        this.snapshots = ModelTypeHelper.unmodifiable(builder.snapshots);
        this.total = Objects.requireNonNull(builder.total, "total");
        this.remaining = Objects.requireNonNull(builder.remaining, "remaining");
    }

    public GetResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<SnapshotResponseItem> responses() {
        return this.responses;
    }

    @Nullable
    public List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    public int total() {
        return this.total;
    }

    public int remaining() {
        return this.remaining;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.responses != null) {
            generator.writeKey("responses");
            generator.writeStartArray();
            for (SnapshotResponseItem snapshotResponseItem : this.responses) {
                snapshotResponseItem.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.snapshots != null) {
            generator.writeKey("snapshots");
            generator.writeStartArray();
            for (SnapshotInfo snapshotInfo : this.snapshots) {
                snapshotInfo.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("remaining");
        generator.write(this.remaining);
    }

    protected static void setupGetResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::responses, JsonpDeserializer.arrayDeserializer(SnapshotResponseItem._DESERIALIZER), "responses", new String[0]);
        op.add(Builder::snapshots, JsonpDeserializer.arrayDeserializer(SnapshotInfo._DESERIALIZER), "snapshots", new String[0]);
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total", new String[0]);
        op.add(Builder::remaining, JsonpDeserializer.integerDeserializer(), "remaining", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetResponse> {
        @Nullable
        private List<SnapshotResponseItem> responses;
        @Nullable
        private List<SnapshotInfo> snapshots;
        private Integer total;
        private Integer remaining;

        public Builder responses(@Nullable List<SnapshotResponseItem> value) {
            this.responses = value;
            return this;
        }

        public Builder responses(SnapshotResponseItem ... value) {
            this.responses = Arrays.asList(value);
            return this;
        }

        public Builder addResponses(SnapshotResponseItem value) {
            if (this.responses == null) {
                this.responses = new ArrayList<SnapshotResponseItem>();
            }
            this.responses.add(value);
            return this;
        }

        public Builder responses(Function<SnapshotResponseItem.Builder, ObjectBuilder<SnapshotResponseItem>> fn) {
            return this.responses(fn.apply(new SnapshotResponseItem.Builder()).build());
        }

        public Builder addResponses(Function<SnapshotResponseItem.Builder, ObjectBuilder<SnapshotResponseItem>> fn) {
            return this.addResponses(fn.apply(new SnapshotResponseItem.Builder()).build());
        }

        public Builder snapshots(@Nullable List<SnapshotInfo> value) {
            this.snapshots = value;
            return this;
        }

        public Builder snapshots(SnapshotInfo ... value) {
            this.snapshots = Arrays.asList(value);
            return this;
        }

        public Builder addSnapshots(SnapshotInfo value) {
            if (this.snapshots == null) {
                this.snapshots = new ArrayList<SnapshotInfo>();
            }
            this.snapshots.add(value);
            return this;
        }

        public Builder snapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.snapshots(fn.apply(new SnapshotInfo.Builder()).build());
        }

        public Builder addSnapshots(Function<SnapshotInfo.Builder, ObjectBuilder<SnapshotInfo>> fn) {
            return this.addSnapshots(fn.apply(new SnapshotInfo.Builder()).build());
        }

        public Builder total(int value) {
            this.total = value;
            return this;
        }

        public Builder remaining(int value) {
            this.remaining = value;
            return this;
        }

        @Override
        public GetResponse build() {
            return new GetResponse(this);
        }
    }
}

