/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.slm.GetLifecycleResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class GetLifecycleRequest
extends RequestBase {
    @Nullable
    private final List<String> policyId;
    public static final Endpoint<GetLifecycleRequest, GetLifecycleResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetLifecycleRequest, GetLifecycleResponse>(request -> "GET", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (request.policyId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetLifecycleResponse._DESERIALIZER);

    public GetLifecycleRequest(Builder builder) {
        this.policyId = ModelTypeHelper.unmodifiable(builder.policyId);
    }

    public GetLifecycleRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> policyId() {
        return this.policyId;
    }

    public static class Builder
    implements ObjectBuilder<GetLifecycleRequest> {
        @Nullable
        private List<String> policyId;

        public Builder policyId(@Nullable List<String> value) {
            this.policyId = value;
            return this;
        }

        public Builder policyId(String ... value) {
            this.policyId = Arrays.asList(value);
            return this;
        }

        public Builder addPolicyId(String value) {
            if (this.policyId == null) {
                this.policyId = new ArrayList<String>();
            }
            this.policyId.add(value);
            return this;
        }

        @Override
        public GetLifecycleRequest build() {
            return new GetLifecycleRequest(this);
        }
    }
}

