/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_token;

import co.elastic.clients.elasticsearch.security.User;
import co.elastic.clients.elasticsearch.security.get_token.AuthenticationProvider;
import co.elastic.clients.elasticsearch.security.get_token.UserRealm;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AuthenticatedUser
extends User {
    private final UserRealm authenticationRealm;
    private final UserRealm lookupRealm;
    @Nullable
    private final AuthenticationProvider authenticationProvider;
    private final String authenticationType;
    public static final JsonpDeserializer<AuthenticatedUser> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AuthenticatedUser::setupAuthenticatedUserDeserializer, Builder::build);

    public AuthenticatedUser(Builder builder) {
        super(builder);
        this.authenticationRealm = Objects.requireNonNull(builder.authenticationRealm, "authentication_realm");
        this.lookupRealm = Objects.requireNonNull(builder.lookupRealm, "lookup_realm");
        this.authenticationProvider = builder.authenticationProvider;
        this.authenticationType = Objects.requireNonNull(builder.authenticationType, "authentication_type");
    }

    public AuthenticatedUser(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public UserRealm authenticationRealm() {
        return this.authenticationRealm;
    }

    public UserRealm lookupRealm() {
        return this.lookupRealm;
    }

    @Nullable
    public AuthenticationProvider authenticationProvider() {
        return this.authenticationProvider;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("authentication_realm");
        this.authenticationRealm.serialize(generator, mapper);
        generator.writeKey("lookup_realm");
        this.lookupRealm.serialize(generator, mapper);
        if (this.authenticationProvider != null) {
            generator.writeKey("authentication_provider");
            this.authenticationProvider.serialize(generator, mapper);
        }
        generator.writeKey("authentication_type");
        generator.write(this.authenticationType);
    }

    protected static void setupAuthenticatedUserDeserializer(DelegatingDeserializer<Builder> op) {
        User.setupUserDeserializer(op);
        op.add(Builder::authenticationRealm, UserRealm._DESERIALIZER, "authentication_realm", new String[0]);
        op.add(Builder::lookupRealm, UserRealm._DESERIALIZER, "lookup_realm", new String[0]);
        op.add(Builder::authenticationProvider, AuthenticationProvider._DESERIALIZER, "authentication_provider", new String[0]);
        op.add(Builder::authenticationType, JsonpDeserializer.stringDeserializer(), "authentication_type", new String[0]);
    }

    public static class Builder
    extends User.AbstractBuilder<Builder>
    implements ObjectBuilder<AuthenticatedUser> {
        private UserRealm authenticationRealm;
        private UserRealm lookupRealm;
        @Nullable
        private AuthenticationProvider authenticationProvider;
        private String authenticationType;

        public Builder authenticationRealm(UserRealm value) {
            this.authenticationRealm = value;
            return this;
        }

        public Builder authenticationRealm(Function<UserRealm.Builder, ObjectBuilder<UserRealm>> fn) {
            return this.authenticationRealm(fn.apply(new UserRealm.Builder()).build());
        }

        public Builder lookupRealm(UserRealm value) {
            this.lookupRealm = value;
            return this;
        }

        public Builder lookupRealm(Function<UserRealm.Builder, ObjectBuilder<UserRealm>> fn) {
            return this.lookupRealm(fn.apply(new UserRealm.Builder()).build());
        }

        public Builder authenticationProvider(@Nullable AuthenticationProvider value) {
            this.authenticationProvider = value;
            return this;
        }

        public Builder authenticationProvider(Function<AuthenticationProvider.Builder, ObjectBuilder<AuthenticationProvider>> fn) {
            return this.authenticationProvider(fn.apply(new AuthenticationProvider.Builder()).build());
        }

        public Builder authenticationType(String value) {
            this.authenticationType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AuthenticatedUser build() {
            return new AuthenticatedUser(this);
        }
    }
}

