/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.InvalidateTokenResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InvalidateTokenRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String token;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final String realmName;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<InvalidateTokenRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateTokenRequest::setupInvalidateTokenRequestDeserializer, Builder::build);
    public static final Endpoint<InvalidateTokenRequest, InvalidateTokenResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<InvalidateTokenRequest, InvalidateTokenResponse>(request -> "DELETE", request -> "/_security/oauth2/token", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, InvalidateTokenResponse._DESERIALIZER);

    public InvalidateTokenRequest(Builder builder) {
        this.token = builder.token;
        this.refreshToken = builder.refreshToken;
        this.realmName = builder.realmName;
        this.username = builder.username;
    }

    public InvalidateTokenRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String token() {
        return this.token;
    }

    @Nullable
    public String refreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public String realmName() {
        return this.realmName;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.token != null) {
            generator.writeKey("token");
            generator.write(this.token);
        }
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
        if (this.realmName != null) {
            generator.writeKey("realm_name");
            generator.write(this.realmName);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    protected static void setupInvalidateTokenRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::token, JsonpDeserializer.stringDeserializer(), "token", new String[0]);
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token", new String[0]);
        op.add(Builder::realmName, JsonpDeserializer.stringDeserializer(), "realm_name", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InvalidateTokenRequest> {
        @Nullable
        private String token;
        @Nullable
        private String refreshToken;
        @Nullable
        private String realmName;
        @Nullable
        private String username;

        public Builder token(@Nullable String value) {
            this.token = value;
            return this;
        }

        public Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        public Builder realmName(@Nullable String value) {
            this.realmName = value;
            return this;
        }

        public Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        public InvalidateTokenRequest build() {
            return new InvalidateTokenRequest(this);
        }
    }
}

