/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetServiceCredentialsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class GetServiceCredentialsRequest
extends RequestBase {
    private final String namespace;
    private final String service;
    public static final Endpoint<GetServiceCredentialsRequest, GetServiceCredentialsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetServiceCredentialsRequest, GetServiceCredentialsResponse>(request -> "GET", request -> {
        boolean _namespace = true;
        int _service = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetServiceCredentialsResponse._DESERIALIZER);

    public GetServiceCredentialsRequest(Builder builder) {
        this.namespace = Objects.requireNonNull(builder.namespace, "namespace");
        this.service = Objects.requireNonNull(builder.service, "service");
    }

    public GetServiceCredentialsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String namespace() {
        return this.namespace;
    }

    public String service() {
        return this.service;
    }

    public static class Builder
    implements ObjectBuilder<GetServiceCredentialsRequest> {
        private String namespace;
        private String service;

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder service(String value) {
            this.service = value;
            return this;
        }

        @Override
        public GetServiceCredentialsRequest build() {
            return new GetServiceCredentialsRequest(this);
        }
    }
}

