/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoNetworkInterface
implements JsonpSerializable {
    private final String address;
    private final String macAddress;
    private final String name;
    public static final JsonpDeserializer<NodeInfoNetworkInterface> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoNetworkInterface::setupNodeInfoNetworkInterfaceDeserializer, Builder::build);

    public NodeInfoNetworkInterface(Builder builder) {
        this.address = Objects.requireNonNull(builder.address, "address");
        this.macAddress = Objects.requireNonNull(builder.macAddress, "mac_address");
        this.name = Objects.requireNonNull(builder.name, "name");
    }

    public NodeInfoNetworkInterface(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String address() {
        return this.address;
    }

    public String macAddress() {
        return this.macAddress;
    }

    public String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("address");
        generator.write(this.address);
        generator.writeKey("mac_address");
        generator.write(this.macAddress);
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupNodeInfoNetworkInterfaceDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::address, JsonpDeserializer.stringDeserializer(), "address", new String[0]);
        op.add(Builder::macAddress, JsonpDeserializer.stringDeserializer(), "mac_address", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoNetworkInterface> {
        private String address;
        private String macAddress;
        private String name;

        public Builder address(String value) {
            this.address = value;
            return this;
        }

        public Builder macAddress(String value) {
            this.macAddress = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public NodeInfoNetworkInterface build() {
            return new NodeInfoNetworkInterface(this);
        }
    }
}

