/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Transport
implements JsonpSerializable {
    private final long rxCount;
    private final String rxSize;
    private final long rxSizeInBytes;
    private final int serverOpen;
    private final long txCount;
    private final String txSize;
    private final long txSizeInBytes;
    public static final JsonpDeserializer<Transport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Transport::setupTransportDeserializer, Builder::build);

    public Transport(Builder builder) {
        this.rxCount = Objects.requireNonNull(builder.rxCount, "rx_count");
        this.rxSize = Objects.requireNonNull(builder.rxSize, "rx_size");
        this.rxSizeInBytes = Objects.requireNonNull(builder.rxSizeInBytes, "rx_size_in_bytes");
        this.serverOpen = Objects.requireNonNull(builder.serverOpen, "server_open");
        this.txCount = Objects.requireNonNull(builder.txCount, "tx_count");
        this.txSize = Objects.requireNonNull(builder.txSize, "tx_size");
        this.txSizeInBytes = Objects.requireNonNull(builder.txSizeInBytes, "tx_size_in_bytes");
    }

    public Transport(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long rxCount() {
        return this.rxCount;
    }

    public String rxSize() {
        return this.rxSize;
    }

    public long rxSizeInBytes() {
        return this.rxSizeInBytes;
    }

    public int serverOpen() {
        return this.serverOpen;
    }

    public long txCount() {
        return this.txCount;
    }

    public String txSize() {
        return this.txSize;
    }

    public long txSizeInBytes() {
        return this.txSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rx_count");
        generator.write(this.rxCount);
        generator.writeKey("rx_size");
        generator.write(this.rxSize);
        generator.writeKey("rx_size_in_bytes");
        generator.write(this.rxSizeInBytes);
        generator.writeKey("server_open");
        generator.write(this.serverOpen);
        generator.writeKey("tx_count");
        generator.write(this.txCount);
        generator.writeKey("tx_size");
        generator.write(this.txSize);
        generator.writeKey("tx_size_in_bytes");
        generator.write(this.txSizeInBytes);
    }

    protected static void setupTransportDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::rxCount, JsonpDeserializer.longDeserializer(), "rx_count", new String[0]);
        op.add(Builder::rxSize, JsonpDeserializer.stringDeserializer(), "rx_size", new String[0]);
        op.add(Builder::rxSizeInBytes, JsonpDeserializer.longDeserializer(), "rx_size_in_bytes", new String[0]);
        op.add(Builder::serverOpen, JsonpDeserializer.integerDeserializer(), "server_open", new String[0]);
        op.add(Builder::txCount, JsonpDeserializer.longDeserializer(), "tx_count", new String[0]);
        op.add(Builder::txSize, JsonpDeserializer.stringDeserializer(), "tx_size", new String[0]);
        op.add(Builder::txSizeInBytes, JsonpDeserializer.longDeserializer(), "tx_size_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Transport> {
        private Long rxCount;
        private String rxSize;
        private Long rxSizeInBytes;
        private Integer serverOpen;
        private Long txCount;
        private String txSize;
        private Long txSizeInBytes;

        public Builder rxCount(long value) {
            this.rxCount = value;
            return this;
        }

        public Builder rxSize(String value) {
            this.rxSize = value;
            return this;
        }

        public Builder rxSizeInBytes(long value) {
            this.rxSizeInBytes = value;
            return this;
        }

        public Builder serverOpen(int value) {
            this.serverOpen = value;
            return this;
        }

        public Builder txCount(long value) {
            this.txCount = value;
            return this;
        }

        public Builder txSize(String value) {
            this.txSize = value;
            return this;
        }

        public Builder txSizeInBytes(long value) {
            this.txSizeInBytes = value;
            return this;
        }

        @Override
        public Transport build() {
            return new Transport(this);
        }
    }
}

