/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ExtendedMemoryStats
extends MemoryStats {
    private final int freePercent;
    private final int usedPercent;
    public static final JsonpDeserializer<ExtendedMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedMemoryStats::setupExtendedMemoryStatsDeserializer, Builder::build);

    public ExtendedMemoryStats(Builder builder) {
        super(builder);
        this.freePercent = Objects.requireNonNull(builder.freePercent, "free_percent");
        this.usedPercent = Objects.requireNonNull(builder.usedPercent, "used_percent");
    }

    public ExtendedMemoryStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int freePercent() {
        return this.freePercent;
    }

    public int usedPercent() {
        return this.usedPercent;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("free_percent");
        generator.write(this.freePercent);
        generator.writeKey("used_percent");
        generator.write(this.usedPercent);
    }

    protected static void setupExtendedMemoryStatsDeserializer(DelegatingDeserializer<Builder> op) {
        MemoryStats.setupMemoryStatsDeserializer(op);
        op.add(Builder::freePercent, JsonpDeserializer.integerDeserializer(), "free_percent", new String[0]);
        op.add(Builder::usedPercent, JsonpDeserializer.integerDeserializer(), "used_percent", new String[0]);
    }

    public static class Builder
    extends MemoryStats.AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedMemoryStats> {
        private Integer freePercent;
        private Integer usedPercent;

        public Builder freePercent(int value) {
            this.freePercent = value;
            return this;
        }

        public Builder usedPercent(int value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedMemoryStats build() {
            return new ExtendedMemoryStats(this);
        }
    }
}

