/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeEvaluationClass;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataframeClassificationSummaryAccuracy
implements JsonpSerializable {
    private final List<DataframeEvaluationClass> classes;
    private final double overallAccuracy;
    public static final JsonpDeserializer<DataframeClassificationSummaryAccuracy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeClassificationSummaryAccuracy::setupDataframeClassificationSummaryAccuracyDeserializer, Builder::build);

    public DataframeClassificationSummaryAccuracy(Builder builder) {
        this.classes = ModelTypeHelper.unmodifiableNonNull(builder.classes, "classes");
        this.overallAccuracy = Objects.requireNonNull(builder.overallAccuracy, "overall_accuracy");
    }

    public DataframeClassificationSummaryAccuracy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<DataframeEvaluationClass> classes() {
        return this.classes;
    }

    public double overallAccuracy() {
        return this.overallAccuracy;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("classes");
        generator.writeStartArray();
        for (DataframeEvaluationClass item0 : this.classes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("overall_accuracy");
        generator.write(this.overallAccuracy);
    }

    protected static void setupDataframeClassificationSummaryAccuracyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::classes, JsonpDeserializer.arrayDeserializer(DataframeEvaluationClass._DESERIALIZER), "classes", new String[0]);
        op.add(Builder::overallAccuracy, JsonpDeserializer.doubleDeserializer(), "overall_accuracy", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeClassificationSummaryAccuracy> {
        private List<DataframeEvaluationClass> classes;
        private Double overallAccuracy;

        public Builder classes(List<DataframeEvaluationClass> value) {
            this.classes = value;
            return this;
        }

        public Builder classes(DataframeEvaluationClass ... value) {
            this.classes = Arrays.asList(value);
            return this;
        }

        public Builder addClasses(DataframeEvaluationClass value) {
            if (this.classes == null) {
                this.classes = new ArrayList<DataframeEvaluationClass>();
            }
            this.classes.add(value);
            return this;
        }

        public Builder classes(Function<DataframeEvaluationClass.Builder, ObjectBuilder<DataframeEvaluationClass>> fn) {
            return this.classes(fn.apply(new DataframeEvaluationClass.Builder()).build());
        }

        public Builder addClasses(Function<DataframeEvaluationClass.Builder, ObjectBuilder<DataframeEvaluationClass>> fn) {
            return this.addClasses(fn.apply(new DataframeEvaluationClass.Builder()).build());
        }

        public Builder overallAccuracy(double value) {
            this.overallAccuracy = value;
            return this;
        }

        @Override
        public DataframeClassificationSummaryAccuracy build() {
            return new DataframeClassificationSummaryAccuracy(this);
        }
    }
}

