/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TimingStats
implements JsonpSerializable {
    private final int elapsedTime;
    @Nullable
    private final Integer iterationTime;
    public static final JsonpDeserializer<TimingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimingStats::setupTimingStatsDeserializer, Builder::build);

    public TimingStats(Builder builder) {
        this.elapsedTime = Objects.requireNonNull(builder.elapsedTime, "elapsed_time");
        this.iterationTime = builder.iterationTime;
    }

    public TimingStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int elapsedTime() {
        return this.elapsedTime;
    }

    @Nullable
    public Integer iterationTime() {
        return this.iterationTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("elapsed_time");
        generator.write(this.elapsedTime);
        if (this.iterationTime != null) {
            generator.writeKey("iteration_time");
            generator.write(this.iterationTime.intValue());
        }
    }

    protected static void setupTimingStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::elapsedTime, JsonpDeserializer.integerDeserializer(), "elapsed_time", new String[0]);
        op.add(Builder::iterationTime, JsonpDeserializer.integerDeserializer(), "iteration_time", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TimingStats> {
        private Integer elapsedTime;
        @Nullable
        private Integer iterationTime;

        public Builder elapsedTime(int value) {
            this.elapsedTime = value;
            return this;
        }

        public Builder iterationTime(@Nullable Integer value) {
            this.iterationTime = value;
            return this;
        }

        @Override
        public TimingStats build() {
            return new TimingStats(this);
        }
    }
}

