/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.StopDataFrameAnalyticsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StopDataFrameAnalyticsRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    @Nullable
    private final String timeout;
    public static final Endpoint<StopDataFrameAnalyticsRequest, StopDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StopDataFrameAnalyticsRequest, StopDataFrameAnalyticsResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_stop");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StopDataFrameAnalyticsResponse._DESERIALIZER);

    public StopDataFrameAnalyticsRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.timeout = builder.timeout;
    }

    public StopDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean force() {
        return this.force;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<StopDataFrameAnalyticsRequest> {
        private String id;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        @Nullable
        private String timeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public StopDataFrameAnalyticsRequest build() {
            return new StopDataFrameAnalyticsRequest(this);
        }
    }
}

