/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.StartDataFrameAnalyticsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StartDataFrameAnalyticsRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final String timeout;
    public static final Endpoint<StartDataFrameAnalyticsRequest, StartDataFrameAnalyticsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StartDataFrameAnalyticsRequest, StartDataFrameAnalyticsResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StartDataFrameAnalyticsResponse._DESERIALIZER);

    public StartDataFrameAnalyticsRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.timeout = builder.timeout;
    }

    public StartDataFrameAnalyticsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<StartDataFrameAnalyticsRequest> {
        private String id;
        @Nullable
        private String timeout;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public StartDataFrameAnalyticsRequest build() {
            return new StartDataFrameAnalyticsRequest(this);
        }
    }
}

