/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfig;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelResponse;
import co.elastic.clients.elasticsearch.ml.put_trained_model.Definition;
import co.elastic.clients.elasticsearch.ml.put_trained_model.Input;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutTrainedModelRequest
extends RequestBase
implements JsonpSerializable {
    private final String modelId;
    @Nullable
    private final String compressedDefinition;
    @Nullable
    private final Definition definition;
    @Nullable
    private final String description;
    private final InferenceConfig inferenceConfig;
    private final Input input;
    @Nullable
    private final JsonData metadata;
    @Nullable
    private final List<String> tags;
    public static final JsonpDeserializer<PutTrainedModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTrainedModelRequest::setupPutTrainedModelRequestDeserializer, Builder::build);
    public static final Endpoint<PutTrainedModelRequest, PutTrainedModelResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutTrainedModelRequest, PutTrainedModelResponse>(request -> "PUT", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutTrainedModelResponse._DESERIALIZER);

    public PutTrainedModelRequest(Builder builder) {
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
        this.compressedDefinition = builder.compressedDefinition;
        this.definition = builder.definition;
        this.description = builder.description;
        this.inferenceConfig = Objects.requireNonNull(builder.inferenceConfig, "inference_config");
        this.input = Objects.requireNonNull(builder.input, "input");
        this.metadata = builder.metadata;
        this.tags = ModelTypeHelper.unmodifiable(builder.tags);
    }

    public PutTrainedModelRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modelId() {
        return this.modelId;
    }

    @Nullable
    public String compressedDefinition() {
        return this.compressedDefinition;
    }

    @Nullable
    public Definition definition() {
        return this.definition;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public Input input() {
        return this.input;
    }

    @Nullable
    public JsonData metadata() {
        return this.metadata;
    }

    @Nullable
    public List<String> tags() {
        return this.tags;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compressedDefinition != null) {
            generator.writeKey("compressed_definition");
            generator.write(this.compressedDefinition);
        }
        if (this.definition != null) {
            generator.writeKey("definition");
            this.definition.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("inference_config");
        this.inferenceConfig.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (this.metadata != null) {
            generator.writeKey("metadata");
            this.metadata.serialize(generator, mapper);
        }
        if (this.tags != null) {
            generator.writeKey("tags");
            generator.writeStartArray();
            for (String item0 : this.tags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutTrainedModelRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::compressedDefinition, JsonpDeserializer.stringDeserializer(), "compressed_definition", new String[0]);
        op.add(Builder::definition, Definition._DESERIALIZER, "definition", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config", new String[0]);
        op.add(Builder::input, Input._DESERIALIZER, "input", new String[0]);
        op.add(Builder::metadata, JsonData._DESERIALIZER, "metadata", new String[0]);
        op.add(Builder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutTrainedModelRequest> {
        private String modelId;
        @Nullable
        private String compressedDefinition;
        @Nullable
        private Definition definition;
        @Nullable
        private String description;
        private InferenceConfig inferenceConfig;
        private Input input;
        @Nullable
        private JsonData metadata;
        @Nullable
        private List<String> tags;

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public Builder compressedDefinition(@Nullable String value) {
            this.compressedDefinition = value;
            return this;
        }

        public Builder definition(@Nullable Definition value) {
            this.definition = value;
            return this;
        }

        public Builder definition(Function<Definition.Builder, ObjectBuilder<Definition>> fn) {
            return this.definition(fn.apply(new Definition.Builder()).build());
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder inferenceConfig(InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        public Builder input(Input value) {
            this.input = value;
            return this;
        }

        public Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public Builder metadata(@Nullable JsonData value) {
            this.metadata = value;
            return this;
        }

        public Builder tags(@Nullable List<String> value) {
            this.tags = value;
            return this;
        }

        public Builder tags(String ... value) {
            this.tags = Arrays.asList(value);
            return this;
        }

        public Builder addTags(String value) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(value);
            return this;
        }

        @Override
        public PutTrainedModelRequest build() {
            return new PutTrainedModelRequest(this);
        }
    }
}

