/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.CalendarEvent;
import co.elastic.clients.elasticsearch.ml.PostCalendarEventsResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PostCalendarEventsRequest
extends RequestBase
implements JsonpSerializable {
    private final String calendarId;
    private final List<CalendarEvent> events;
    public static final JsonpDeserializer<PostCalendarEventsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostCalendarEventsRequest::setupPostCalendarEventsRequestDeserializer, Builder::build);
    public static final Endpoint<PostCalendarEventsRequest, PostCalendarEventsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PostCalendarEventsRequest, PostCalendarEventsResponse>(request -> "POST", request -> {
        boolean _calendarId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/calendars");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.calendarId, buf);
            buf.append("/events");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PostCalendarEventsResponse._DESERIALIZER);

    public PostCalendarEventsRequest(Builder builder) {
        this.calendarId = Objects.requireNonNull(builder.calendarId, "calendar_id");
        this.events = ModelTypeHelper.unmodifiableNonNull(builder.events, "events");
    }

    public PostCalendarEventsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String calendarId() {
        return this.calendarId;
    }

    public List<CalendarEvent> events() {
        return this.events;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("events");
        generator.writeStartArray();
        for (CalendarEvent item0 : this.events) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupPostCalendarEventsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::events, JsonpDeserializer.arrayDeserializer(CalendarEvent._DESERIALIZER), "events", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PostCalendarEventsRequest> {
        private String calendarId;
        private List<CalendarEvent> events;

        public Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public Builder events(List<CalendarEvent> value) {
            this.events = value;
            return this;
        }

        public Builder events(CalendarEvent ... value) {
            this.events = Arrays.asList(value);
            return this;
        }

        public Builder addEvents(CalendarEvent value) {
            if (this.events == null) {
                this.events = new ArrayList<CalendarEvent>();
            }
            this.events.add(value);
            return this;
        }

        public Builder events(Function<CalendarEvent.Builder, ObjectBuilder<CalendarEvent>> fn) {
            return this.events(fn.apply(new CalendarEvent.Builder()).build());
        }

        public Builder addEvents(Function<CalendarEvent.Builder, ObjectBuilder<CalendarEvent>> fn) {
            return this.addEvents(fn.apply(new CalendarEvent.Builder()).build());
        }

        @Override
        public PostCalendarEventsRequest build() {
            return new PostCalendarEventsRequest(this);
        }
    }
}

