/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.JobStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetJobStatsResponse
implements JsonpSerializable {
    private final long count;
    private final List<JobStats> jobs;
    public static final JsonpDeserializer<GetJobStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetJobStatsResponse::setupGetJobStatsResponseDeserializer, Builder::build);

    public GetJobStatsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.jobs = ModelTypeHelper.unmodifiableNonNull(builder.jobs, "jobs");
    }

    public GetJobStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<JobStats> jobs() {
        return this.jobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("jobs");
        generator.writeStartArray();
        for (JobStats item0 : this.jobs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetJobStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::jobs, JsonpDeserializer.arrayDeserializer(JobStats._DESERIALIZER), "jobs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetJobStatsResponse> {
        private Long count;
        private List<JobStats> jobs;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder jobs(List<JobStats> value) {
            this.jobs = value;
            return this;
        }

        public Builder jobs(JobStats ... value) {
            this.jobs = Arrays.asList(value);
            return this;
        }

        public Builder addJobs(JobStats value) {
            if (this.jobs == null) {
                this.jobs = new ArrayList<JobStats>();
            }
            this.jobs.add(value);
            return this;
        }

        public Builder jobs(Function<JobStats.Builder, ObjectBuilder<JobStats>> fn) {
            return this.jobs(fn.apply(new JobStats.Builder()).build());
        }

        public Builder addJobs(Function<JobStats.Builder, ObjectBuilder<JobStats>> fn) {
            return this.addJobs(fn.apply(new JobStats.Builder()).build());
        }

        @Override
        public GetJobStatsResponse build() {
            return new GetJobStatsResponse(this);
        }
    }
}

