/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDataFrameAnalyticsStatsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetDataFrameAnalyticsStatsRequest
extends RequestBase {
    @Nullable
    private final String id;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final Boolean verbose;
    public static final Endpoint<GetDataFrameAnalyticsStatsRequest, GetDataFrameAnalyticsStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetDataFrameAnalyticsStatsRequest, GetDataFrameAnalyticsStatsResponse>(request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDataFrameAnalyticsStatsResponse._DESERIALIZER);

    public GetDataFrameAnalyticsStatsRequest(Builder builder) {
        this.id = builder.id;
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.size = builder.size;
        this.verbose = builder.verbose;
    }

    public GetDataFrameAnalyticsStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Boolean verbose() {
        return this.verbose;
    }

    public static class Builder
    implements ObjectBuilder<GetDataFrameAnalyticsStatsRequest> {
        @Nullable
        private String id;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private Boolean verbose;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        public GetDataFrameAnalyticsStatsRequest build() {
            return new GetDataFrameAnalyticsStatsRequest(this);
        }
    }
}

