/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSummary;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetDataFrameAnalyticsResponse
implements JsonpSerializable {
    private final int count;
    private final List<DataframeAnalyticsSummary> dataFrameAnalytics;
    public static final JsonpDeserializer<GetDataFrameAnalyticsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDataFrameAnalyticsResponse::setupGetDataFrameAnalyticsResponseDeserializer, Builder::build);

    public GetDataFrameAnalyticsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.dataFrameAnalytics = ModelTypeHelper.unmodifiableNonNull(builder.dataFrameAnalytics, "data_frame_analytics");
    }

    public GetDataFrameAnalyticsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    public List<DataframeAnalyticsSummary> dataFrameAnalytics() {
        return this.dataFrameAnalytics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("data_frame_analytics");
        generator.writeStartArray();
        for (DataframeAnalyticsSummary item0 : this.dataFrameAnalytics) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetDataFrameAnalyticsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::dataFrameAnalytics, JsonpDeserializer.arrayDeserializer(DataframeAnalyticsSummary._DESERIALIZER), "data_frame_analytics", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetDataFrameAnalyticsResponse> {
        private Integer count;
        private List<DataframeAnalyticsSummary> dataFrameAnalytics;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder dataFrameAnalytics(List<DataframeAnalyticsSummary> value) {
            this.dataFrameAnalytics = value;
            return this;
        }

        public Builder dataFrameAnalytics(DataframeAnalyticsSummary ... value) {
            this.dataFrameAnalytics = Arrays.asList(value);
            return this;
        }

        public Builder addDataFrameAnalytics(DataframeAnalyticsSummary value) {
            if (this.dataFrameAnalytics == null) {
                this.dataFrameAnalytics = new ArrayList<DataframeAnalyticsSummary>();
            }
            this.dataFrameAnalytics.add(value);
            return this;
        }

        public Builder dataFrameAnalytics(Function<DataframeAnalyticsSummary.Builder, ObjectBuilder<DataframeAnalyticsSummary>> fn) {
            return this.dataFrameAnalytics(fn.apply(new DataframeAnalyticsSummary.Builder()).build());
        }

        public Builder addDataFrameAnalytics(Function<DataframeAnalyticsSummary.Builder, ObjectBuilder<DataframeAnalyticsSummary>> fn) {
            return this.addDataFrameAnalytics(fn.apply(new DataframeAnalyticsSummary.Builder()).build());
        }

        @Override
        public GetDataFrameAnalyticsResponse build() {
            return new GetDataFrameAnalyticsResponse(this);
        }
    }
}

