/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.DeleteForecastResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeleteForecastRequest
extends RequestBase {
    private final String jobId;
    @Nullable
    private final String forecastId;
    @Nullable
    private final Boolean allowNoForecasts;
    @Nullable
    private final String timeout;
    public static final Endpoint<DeleteForecastRequest, DeleteForecastResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteForecastRequest, DeleteForecastResponse>(request -> "DELETE", request -> {
        boolean _jobId = true;
        int _forecastId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.forecastId() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_forecast");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_forecast");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.forecastId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoForecasts != null) {
            params.put("allow_no_forecasts", String.valueOf(request.allowNoForecasts));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteForecastResponse._DESERIALIZER);

    public DeleteForecastRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.forecastId = builder.forecastId;
        this.allowNoForecasts = builder.allowNoForecasts;
        this.timeout = builder.timeout;
    }

    public DeleteForecastRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String forecastId() {
        return this.forecastId;
    }

    @Nullable
    public Boolean allowNoForecasts() {
        return this.allowNoForecasts;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteForecastRequest> {
        private String jobId;
        @Nullable
        private String forecastId;
        @Nullable
        private Boolean allowNoForecasts;
        @Nullable
        private String timeout;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder forecastId(@Nullable String value) {
            this.forecastId = value;
            return this;
        }

        public Builder allowNoForecasts(@Nullable Boolean value) {
            this.allowNoForecasts = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteForecastRequest build() {
            return new DeleteForecastRequest(this);
        }
    }
}

