/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DelayedDataCheckConfig
implements JsonpSerializable {
    @Nullable
    private final String checkWindow;
    private final boolean enabled;
    public static final JsonpDeserializer<DelayedDataCheckConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelayedDataCheckConfig::setupDelayedDataCheckConfigDeserializer, Builder::build);

    public DelayedDataCheckConfig(Builder builder) {
        this.checkWindow = builder.checkWindow;
        this.enabled = Objects.requireNonNull(builder.enabled, "enabled");
    }

    public DelayedDataCheckConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String checkWindow() {
        return this.checkWindow;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.checkWindow != null) {
            generator.writeKey("check_window");
            generator.write(this.checkWindow);
        }
        generator.writeKey("enabled");
        generator.write(this.enabled);
    }

    protected static void setupDelayedDataCheckConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::checkWindow, JsonpDeserializer.stringDeserializer(), "check_window", new String[0]);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DelayedDataCheckConfig> {
        @Nullable
        private String checkWindow;
        private Boolean enabled;

        public Builder checkWindow(@Nullable String value) {
            this.checkWindow = value;
            return this;
        }

        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        public DelayedDataCheckConfig build() {
            return new DelayedDataCheckConfig(this);
        }
    }
}

