/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.BucketInfluencer;
import co.elastic.clients.elasticsearch.ml.PartitionScore;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class BucketSummary
implements JsonpSerializable {
    private final double anomalyScore;
    private final List<BucketInfluencer> bucketInfluencers;
    private final String bucketSpan;
    private final long eventCount;
    private final double initialAnomalyScore;
    private final boolean isInterim;
    private final String jobId;
    @Nullable
    private final List<PartitionScore> partitionScores;
    private final double processingTimeMs;
    private final String resultType;
    private final String timestamp;
    public static final JsonpDeserializer<BucketSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketSummary::setupBucketSummaryDeserializer, Builder::build);

    public BucketSummary(Builder builder) {
        this.anomalyScore = Objects.requireNonNull(builder.anomalyScore, "anomaly_score");
        this.bucketInfluencers = ModelTypeHelper.unmodifiableNonNull(builder.bucketInfluencers, "bucket_influencers");
        this.bucketSpan = Objects.requireNonNull(builder.bucketSpan, "bucket_span");
        this.eventCount = Objects.requireNonNull(builder.eventCount, "event_count");
        this.initialAnomalyScore = Objects.requireNonNull(builder.initialAnomalyScore, "initial_anomaly_score");
        this.isInterim = Objects.requireNonNull(builder.isInterim, "is_interim");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.partitionScores = ModelTypeHelper.unmodifiable(builder.partitionScores);
        this.processingTimeMs = Objects.requireNonNull(builder.processingTimeMs, "processing_time_ms");
        this.resultType = Objects.requireNonNull(builder.resultType, "result_type");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public BucketSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double anomalyScore() {
        return this.anomalyScore;
    }

    public List<BucketInfluencer> bucketInfluencers() {
        return this.bucketInfluencers;
    }

    public String bucketSpan() {
        return this.bucketSpan;
    }

    public long eventCount() {
        return this.eventCount;
    }

    public double initialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public List<PartitionScore> partitionScores() {
        return this.partitionScores;
    }

    public double processingTimeMs() {
        return this.processingTimeMs;
    }

    public String resultType() {
        return this.resultType;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("anomaly_score");
        generator.write(this.anomalyScore);
        generator.writeKey("bucket_influencers");
        generator.writeStartArray();
        for (BucketInfluencer bucketInfluencer : this.bucketInfluencers) {
            bucketInfluencer.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("event_count");
        generator.write(this.eventCount);
        generator.writeKey("initial_anomaly_score");
        generator.write(this.initialAnomalyScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.partitionScores != null) {
            generator.writeKey("partition_scores");
            generator.writeStartArray();
            for (PartitionScore partitionScore : this.partitionScores) {
                partitionScore.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("processing_time_ms");
        generator.write(this.processingTimeMs);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupBucketSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::anomalyScore, JsonpDeserializer.doubleDeserializer(), "anomaly_score", new String[0]);
        op.add(Builder::bucketInfluencers, JsonpDeserializer.arrayDeserializer(BucketInfluencer._DESERIALIZER), "bucket_influencers", new String[0]);
        op.add(Builder::bucketSpan, JsonpDeserializer.stringDeserializer(), "bucket_span", new String[0]);
        op.add(Builder::eventCount, JsonpDeserializer.longDeserializer(), "event_count", new String[0]);
        op.add(Builder::initialAnomalyScore, JsonpDeserializer.doubleDeserializer(), "initial_anomaly_score", new String[0]);
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::partitionScores, JsonpDeserializer.arrayDeserializer(PartitionScore._DESERIALIZER), "partition_scores", new String[0]);
        op.add(Builder::processingTimeMs, JsonpDeserializer.doubleDeserializer(), "processing_time_ms", new String[0]);
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<BucketSummary> {
        private Double anomalyScore;
        private List<BucketInfluencer> bucketInfluencers;
        private String bucketSpan;
        private Long eventCount;
        private Double initialAnomalyScore;
        private Boolean isInterim;
        private String jobId;
        @Nullable
        private List<PartitionScore> partitionScores;
        private Double processingTimeMs;
        private String resultType;
        private String timestamp;

        public Builder anomalyScore(double value) {
            this.anomalyScore = value;
            return this;
        }

        public Builder bucketInfluencers(List<BucketInfluencer> value) {
            this.bucketInfluencers = value;
            return this;
        }

        public Builder bucketInfluencers(BucketInfluencer ... value) {
            this.bucketInfluencers = Arrays.asList(value);
            return this;
        }

        public Builder addBucketInfluencers(BucketInfluencer value) {
            if (this.bucketInfluencers == null) {
                this.bucketInfluencers = new ArrayList<BucketInfluencer>();
            }
            this.bucketInfluencers.add(value);
            return this;
        }

        public Builder bucketInfluencers(Function<BucketInfluencer.Builder, ObjectBuilder<BucketInfluencer>> fn) {
            return this.bucketInfluencers(fn.apply(new BucketInfluencer.Builder()).build());
        }

        public Builder addBucketInfluencers(Function<BucketInfluencer.Builder, ObjectBuilder<BucketInfluencer>> fn) {
            return this.addBucketInfluencers(fn.apply(new BucketInfluencer.Builder()).build());
        }

        public Builder bucketSpan(String value) {
            this.bucketSpan = value;
            return this;
        }

        public Builder eventCount(long value) {
            this.eventCount = value;
            return this;
        }

        public Builder initialAnomalyScore(double value) {
            this.initialAnomalyScore = value;
            return this;
        }

        public Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder partitionScores(@Nullable List<PartitionScore> value) {
            this.partitionScores = value;
            return this;
        }

        public Builder partitionScores(PartitionScore ... value) {
            this.partitionScores = Arrays.asList(value);
            return this;
        }

        public Builder addPartitionScores(PartitionScore value) {
            if (this.partitionScores == null) {
                this.partitionScores = new ArrayList<PartitionScore>();
            }
            this.partitionScores.add(value);
            return this;
        }

        public Builder partitionScores(Function<PartitionScore.Builder, ObjectBuilder<PartitionScore>> fn) {
            return this.partitionScores(fn.apply(new PartitionScore.Builder()).build());
        }

        public Builder addPartitionScores(Function<PartitionScore.Builder, ObjectBuilder<PartitionScore>> fn) {
            return this.addPartitionScores(fn.apply(new PartitionScore.Builder()).build());
        }

        public Builder processingTimeMs(double value) {
            this.processingTimeMs = value;
            return this;
        }

        public Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public BucketSummary build() {
            return new BucketSummary(this);
        }
    }
}

