/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.AnomalyCause;
import co.elastic.clients.elasticsearch.ml.Influence;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Anomaly
implements JsonpSerializable {
    @Nullable
    private final List<Double> actual;
    private final String bucketSpan;
    @Nullable
    private final String byFieldName;
    @Nullable
    private final String byFieldValue;
    @Nullable
    private final List<AnomalyCause> causes;
    private final int detectorIndex;
    @Nullable
    private final String fieldName;
    @Nullable
    private final String function;
    @Nullable
    private final String functionDescription;
    @Nullable
    private final List<Influence> influencers;
    private final double initialRecordScore;
    private final boolean isInterim;
    private final String jobId;
    @Nullable
    private final String overFieldName;
    @Nullable
    private final String overFieldValue;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final String partitionFieldValue;
    private final double probability;
    private final double recordScore;
    private final String resultType;
    private final String timestamp;
    @Nullable
    private final List<Double> typical;
    public static final JsonpDeserializer<Anomaly> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Anomaly::setupAnomalyDeserializer, Builder::build);

    public Anomaly(Builder builder) {
        this.actual = ModelTypeHelper.unmodifiable(builder.actual);
        this.bucketSpan = Objects.requireNonNull(builder.bucketSpan, "bucket_span");
        this.byFieldName = builder.byFieldName;
        this.byFieldValue = builder.byFieldValue;
        this.causes = ModelTypeHelper.unmodifiable(builder.causes);
        this.detectorIndex = Objects.requireNonNull(builder.detectorIndex, "detector_index");
        this.fieldName = builder.fieldName;
        this.function = builder.function;
        this.functionDescription = builder.functionDescription;
        this.influencers = ModelTypeHelper.unmodifiable(builder.influencers);
        this.initialRecordScore = Objects.requireNonNull(builder.initialRecordScore, "initial_record_score");
        this.isInterim = Objects.requireNonNull(builder.isInterim, "is_interim");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.overFieldName = builder.overFieldName;
        this.overFieldValue = builder.overFieldValue;
        this.partitionFieldName = builder.partitionFieldName;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.probability = Objects.requireNonNull(builder.probability, "probability");
        this.recordScore = Objects.requireNonNull(builder.recordScore, "record_score");
        this.resultType = Objects.requireNonNull(builder.resultType, "result_type");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
        this.typical = ModelTypeHelper.unmodifiable(builder.typical);
    }

    public Anomaly(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<Double> actual() {
        return this.actual;
    }

    public String bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public String byFieldName() {
        return this.byFieldName;
    }

    @Nullable
    public String byFieldValue() {
        return this.byFieldValue;
    }

    @Nullable
    public List<AnomalyCause> causes() {
        return this.causes;
    }

    public int detectorIndex() {
        return this.detectorIndex;
    }

    @Nullable
    public String fieldName() {
        return this.fieldName;
    }

    @Nullable
    public String function() {
        return this.function;
    }

    @Nullable
    public String functionDescription() {
        return this.functionDescription;
    }

    @Nullable
    public List<Influence> influencers() {
        return this.influencers;
    }

    public double initialRecordScore() {
        return this.initialRecordScore;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String overFieldName() {
        return this.overFieldName;
    }

    @Nullable
    public String overFieldValue() {
        return this.overFieldValue;
    }

    @Nullable
    public String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public double probability() {
        return this.probability;
    }

    public double recordScore() {
        return this.recordScore;
    }

    public String resultType() {
        return this.resultType;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public List<Double> typical() {
        return this.typical;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actual != null) {
            generator.writeKey("actual");
            generator.writeStartArray();
            for (Double d : this.actual) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        if (this.byFieldName != null) {
            generator.writeKey("by_field_name");
            generator.write(this.byFieldName);
        }
        if (this.byFieldValue != null) {
            generator.writeKey("by_field_value");
            generator.write(this.byFieldValue);
        }
        if (this.causes != null) {
            generator.writeKey("causes");
            generator.writeStartArray();
            for (AnomalyCause anomalyCause : this.causes) {
                anomalyCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("detector_index");
        generator.write(this.detectorIndex);
        if (this.fieldName != null) {
            generator.writeKey("field_name");
            generator.write(this.fieldName);
        }
        if (this.function != null) {
            generator.writeKey("function");
            generator.write(this.function);
        }
        if (this.functionDescription != null) {
            generator.writeKey("function_description");
            generator.write(this.functionDescription);
        }
        if (this.influencers != null) {
            generator.writeKey("influencers");
            generator.writeStartArray();
            for (Influence influence : this.influencers) {
                influence.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("initial_record_score");
        generator.write(this.initialRecordScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.overFieldName != null) {
            generator.writeKey("over_field_name");
            generator.write(this.overFieldName);
        }
        if (this.overFieldValue != null) {
            generator.writeKey("over_field_value");
            generator.write(this.overFieldValue);
        }
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            generator.writeKey("partition_field_value");
            generator.write(this.partitionFieldValue);
        }
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("record_score");
        generator.write(this.recordScore);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.typical != null) {
            generator.writeKey("typical");
            generator.writeStartArray();
            for (Double d : this.typical) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupAnomalyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actual, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "actual", new String[0]);
        op.add(Builder::bucketSpan, JsonpDeserializer.stringDeserializer(), "bucket_span", new String[0]);
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name", new String[0]);
        op.add(Builder::byFieldValue, JsonpDeserializer.stringDeserializer(), "by_field_value", new String[0]);
        op.add(Builder::causes, JsonpDeserializer.arrayDeserializer(AnomalyCause._DESERIALIZER), "causes", new String[0]);
        op.add(Builder::detectorIndex, JsonpDeserializer.integerDeserializer(), "detector_index", new String[0]);
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name", new String[0]);
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function", new String[0]);
        op.add(Builder::functionDescription, JsonpDeserializer.stringDeserializer(), "function_description", new String[0]);
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(Influence._DESERIALIZER), "influencers", new String[0]);
        op.add(Builder::initialRecordScore, JsonpDeserializer.doubleDeserializer(), "initial_record_score", new String[0]);
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name", new String[0]);
        op.add(Builder::overFieldValue, JsonpDeserializer.stringDeserializer(), "over_field_value", new String[0]);
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name", new String[0]);
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value", new String[0]);
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability", new String[0]);
        op.add(Builder::recordScore, JsonpDeserializer.doubleDeserializer(), "record_score", new String[0]);
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
        op.add(Builder::typical, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "typical", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Anomaly> {
        @Nullable
        private List<Double> actual;
        private String bucketSpan;
        @Nullable
        private String byFieldName;
        @Nullable
        private String byFieldValue;
        @Nullable
        private List<AnomalyCause> causes;
        private Integer detectorIndex;
        @Nullable
        private String fieldName;
        @Nullable
        private String function;
        @Nullable
        private String functionDescription;
        @Nullable
        private List<Influence> influencers;
        private Double initialRecordScore;
        private Boolean isInterim;
        private String jobId;
        @Nullable
        private String overFieldName;
        @Nullable
        private String overFieldValue;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private String partitionFieldValue;
        private Double probability;
        private Double recordScore;
        private String resultType;
        private String timestamp;
        @Nullable
        private List<Double> typical;

        public Builder actual(@Nullable List<Double> value) {
            this.actual = value;
            return this;
        }

        public Builder actual(Double ... value) {
            this.actual = Arrays.asList(value);
            return this;
        }

        public Builder addActual(Double value) {
            if (this.actual == null) {
                this.actual = new ArrayList<Double>();
            }
            this.actual.add(value);
            return this;
        }

        public Builder bucketSpan(String value) {
            this.bucketSpan = value;
            return this;
        }

        public Builder byFieldName(@Nullable String value) {
            this.byFieldName = value;
            return this;
        }

        public Builder byFieldValue(@Nullable String value) {
            this.byFieldValue = value;
            return this;
        }

        public Builder causes(@Nullable List<AnomalyCause> value) {
            this.causes = value;
            return this;
        }

        public Builder causes(AnomalyCause ... value) {
            this.causes = Arrays.asList(value);
            return this;
        }

        public Builder addCauses(AnomalyCause value) {
            if (this.causes == null) {
                this.causes = new ArrayList<AnomalyCause>();
            }
            this.causes.add(value);
            return this;
        }

        public Builder causes(Function<AnomalyCause.Builder, ObjectBuilder<AnomalyCause>> fn) {
            return this.causes(fn.apply(new AnomalyCause.Builder()).build());
        }

        public Builder addCauses(Function<AnomalyCause.Builder, ObjectBuilder<AnomalyCause>> fn) {
            return this.addCauses(fn.apply(new AnomalyCause.Builder()).build());
        }

        public Builder detectorIndex(int value) {
            this.detectorIndex = value;
            return this;
        }

        public Builder fieldName(@Nullable String value) {
            this.fieldName = value;
            return this;
        }

        public Builder function(@Nullable String value) {
            this.function = value;
            return this;
        }

        public Builder functionDescription(@Nullable String value) {
            this.functionDescription = value;
            return this;
        }

        public Builder influencers(@Nullable List<Influence> value) {
            this.influencers = value;
            return this;
        }

        public Builder influencers(Influence ... value) {
            this.influencers = Arrays.asList(value);
            return this;
        }

        public Builder addInfluencers(Influence value) {
            if (this.influencers == null) {
                this.influencers = new ArrayList<Influence>();
            }
            this.influencers.add(value);
            return this;
        }

        public Builder influencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.influencers(fn.apply(new Influence.Builder()).build());
        }

        public Builder addInfluencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.addInfluencers(fn.apply(new Influence.Builder()).build());
        }

        public Builder initialRecordScore(double value) {
            this.initialRecordScore = value;
            return this;
        }

        public Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder overFieldName(@Nullable String value) {
            this.overFieldName = value;
            return this;
        }

        public Builder overFieldValue(@Nullable String value) {
            this.overFieldValue = value;
            return this;
        }

        public Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public Builder recordScore(double value) {
            this.recordScore = value;
            return this;
        }

        public Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        public Builder typical(@Nullable List<Double> value) {
            this.typical = value;
            return this;
        }

        public Builder typical(Double ... value) {
            this.typical = Arrays.asList(value);
            return this;
        }

        public Builder addTypical(Double value) {
            if (this.typical == null) {
                this.typical = new ArrayList<Double>();
            }
            this.typical.add(value);
            return this;
        }

        @Override
        public Anomaly build() {
            return new Anomaly(this);
        }
    }
}

