/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration;

import co.elastic.clients.elasticsearch.migration.deprecations.Deprecation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class DeprecationsResponse
implements JsonpSerializable {
    private final List<Deprecation> clusterSettings;
    private final Map<String, List<Deprecation>> indexSettings;
    private final List<Deprecation> nodeSettings;
    private final List<Deprecation> mlSettings;
    public static final JsonpDeserializer<DeprecationsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeprecationsResponse::setupDeprecationsResponseDeserializer, Builder::build);

    public DeprecationsResponse(Builder builder) {
        this.clusterSettings = ModelTypeHelper.unmodifiableNonNull(builder.clusterSettings, "cluster_settings");
        this.indexSettings = ModelTypeHelper.unmodifiableNonNull(builder.indexSettings, "index_settings");
        this.nodeSettings = ModelTypeHelper.unmodifiableNonNull(builder.nodeSettings, "node_settings");
        this.mlSettings = ModelTypeHelper.unmodifiableNonNull(builder.mlSettings, "ml_settings");
    }

    public DeprecationsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<Deprecation> clusterSettings() {
        return this.clusterSettings;
    }

    public Map<String, List<Deprecation>> indexSettings() {
        return this.indexSettings;
    }

    public List<Deprecation> nodeSettings() {
        return this.nodeSettings;
    }

    public List<Deprecation> mlSettings() {
        return this.mlSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_settings");
        generator.writeStartArray();
        for (Deprecation deprecation : this.clusterSettings) {
            deprecation.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("index_settings");
        generator.writeStartObject();
        for (Map.Entry entry : this.indexSettings.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.writeStartArray();
            for (Deprecation item1 : (List)entry.getValue()) {
                item1.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("node_settings");
        generator.writeStartArray();
        for (Deprecation deprecation : this.nodeSettings) {
            deprecation.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("ml_settings");
        generator.writeStartArray();
        for (Deprecation deprecation : this.mlSettings) {
            deprecation.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupDeprecationsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::clusterSettings, JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER), "cluster_settings", new String[0]);
        op.add(Builder::indexSettings, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER)), "index_settings", new String[0]);
        op.add(Builder::nodeSettings, JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER), "node_settings", new String[0]);
        op.add(Builder::mlSettings, JsonpDeserializer.arrayDeserializer(Deprecation._DESERIALIZER), "ml_settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DeprecationsResponse> {
        private List<Deprecation> clusterSettings;
        private Map<String, List<Deprecation>> indexSettings;
        private List<Deprecation> nodeSettings;
        private List<Deprecation> mlSettings;

        public Builder clusterSettings(List<Deprecation> value) {
            this.clusterSettings = value;
            return this;
        }

        public Builder clusterSettings(Deprecation ... value) {
            this.clusterSettings = Arrays.asList(value);
            return this;
        }

        public Builder addClusterSettings(Deprecation value) {
            if (this.clusterSettings == null) {
                this.clusterSettings = new ArrayList<Deprecation>();
            }
            this.clusterSettings.add(value);
            return this;
        }

        public Builder clusterSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.clusterSettings(fn.apply(new Deprecation.Builder()).build());
        }

        public Builder addClusterSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.addClusterSettings(fn.apply(new Deprecation.Builder()).build());
        }

        public Builder indexSettings(Map<String, List<Deprecation>> value) {
            this.indexSettings = value;
            return this;
        }

        public Builder putIndexSettings(String key, List<Deprecation> value) {
            if (this.indexSettings == null) {
                this.indexSettings = new HashMap<String, List<Deprecation>>();
            }
            this.indexSettings.put(key, value);
            return this;
        }

        public Builder nodeSettings(List<Deprecation> value) {
            this.nodeSettings = value;
            return this;
        }

        public Builder nodeSettings(Deprecation ... value) {
            this.nodeSettings = Arrays.asList(value);
            return this;
        }

        public Builder addNodeSettings(Deprecation value) {
            if (this.nodeSettings == null) {
                this.nodeSettings = new ArrayList<Deprecation>();
            }
            this.nodeSettings.add(value);
            return this;
        }

        public Builder nodeSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.nodeSettings(fn.apply(new Deprecation.Builder()).build());
        }

        public Builder addNodeSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.addNodeSettings(fn.apply(new Deprecation.Builder()).build());
        }

        public Builder mlSettings(List<Deprecation> value) {
            this.mlSettings = value;
            return this;
        }

        public Builder mlSettings(Deprecation ... value) {
            this.mlSettings = Arrays.asList(value);
            return this;
        }

        public Builder addMlSettings(Deprecation value) {
            if (this.mlSettings == null) {
                this.mlSettings = new ArrayList<Deprecation>();
            }
            this.mlSettings.add(value);
            return this;
        }

        public Builder mlSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.mlSettings(fn.apply(new Deprecation.Builder()).build());
        }

        public Builder addMlSettings(Function<Deprecation.Builder, ObjectBuilder<Deprecation>> fn) {
            return this.addMlSettings(fn.apply(new Deprecation.Builder()).build());
        }

        @Override
        public DeprecationsResponse build() {
            return new DeprecationsResponse(this);
        }
    }
}

