/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.simulate.PipelineSimulation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class SimulateResponse
implements JsonpSerializable {
    private final List<PipelineSimulation> docs;
    public static final JsonpDeserializer<SimulateResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimulateResponse::setupSimulateResponseDeserializer, Builder::build);

    public SimulateResponse(Builder builder) {
        this.docs = ModelTypeHelper.unmodifiableNonNull(builder.docs, "docs");
    }

    public SimulateResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<PipelineSimulation> docs() {
        return this.docs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("docs");
        generator.writeStartArray();
        for (PipelineSimulation item0 : this.docs) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupSimulateResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(PipelineSimulation._DESERIALIZER), "docs", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SimulateResponse> {
        private List<PipelineSimulation> docs;

        public Builder docs(List<PipelineSimulation> value) {
            this.docs = value;
            return this;
        }

        public Builder docs(PipelineSimulation ... value) {
            this.docs = Arrays.asList(value);
            return this;
        }

        public Builder addDocs(PipelineSimulation value) {
            if (this.docs == null) {
                this.docs = new ArrayList<PipelineSimulation>();
            }
            this.docs.add(value);
            return this;
        }

        public Builder docs(Function<PipelineSimulation.Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.docs(fn.apply(new PipelineSimulation.Builder()).build());
        }

        public Builder addDocs(Function<PipelineSimulation.Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.addDocs(fn.apply(new PipelineSimulation.Builder()).build());
        }

        @Override
        public SimulateResponse build() {
            return new SimulateResponse(this);
        }
    }
}

