/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.GeoShapeRelation;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class EnrichProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Integer maxMatches;
    @Nullable
    private final Boolean override;
    private final String policyName;
    @Nullable
    private final GeoShapeRelation shapeRelation;
    private final String targetField;
    public static final JsonpDeserializer<EnrichProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EnrichProcessor::setupEnrichProcessorDeserializer, Builder::build);

    public EnrichProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.maxMatches = builder.maxMatches;
        this.override = builder.override;
        this.policyName = Objects.requireNonNull(builder.policyName, "policy_name");
        this.shapeRelation = builder.shapeRelation;
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
    }

    public EnrichProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "enrich";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public Integer maxMatches() {
        return this.maxMatches;
    }

    @Nullable
    public Boolean override() {
        return this.override;
    }

    public String policyName() {
        return this.policyName;
    }

    @Nullable
    public GeoShapeRelation shapeRelation() {
        return this.shapeRelation;
    }

    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.maxMatches != null) {
            generator.writeKey("max_matches");
            generator.write(this.maxMatches.intValue());
        }
        if (this.override != null) {
            generator.writeKey("override");
            generator.write(this.override.booleanValue());
        }
        generator.writeKey("policy_name");
        generator.write(this.policyName);
        if (this.shapeRelation != null) {
            generator.writeKey("shape_relation");
            this.shapeRelation.serialize(generator, mapper);
        }
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupEnrichProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::maxMatches, JsonpDeserializer.integerDeserializer(), "max_matches", new String[0]);
        op.add(Builder::override, JsonpDeserializer.booleanDeserializer(), "override", new String[0]);
        op.add(Builder::policyName, JsonpDeserializer.stringDeserializer(), "policy_name", new String[0]);
        op.add(Builder::shapeRelation, GeoShapeRelation._DESERIALIZER, "shape_relation", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<EnrichProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Integer maxMatches;
        @Nullable
        private Boolean override;
        private String policyName;
        @Nullable
        private GeoShapeRelation shapeRelation;
        private String targetField;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder maxMatches(@Nullable Integer value) {
            this.maxMatches = value;
            return this;
        }

        public Builder override(@Nullable Boolean value) {
            this.override = value;
            return this;
        }

        public Builder policyName(String value) {
            this.policyName = value;
            return this;
        }

        public Builder shapeRelation(@Nullable GeoShapeRelation value) {
            this.shapeRelation = value;
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EnrichProcessor build() {
            return new EnrichProcessor(this);
        }
    }
}

