/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DotExpanderProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final String path;
    public static final JsonpDeserializer<DotExpanderProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DotExpanderProcessor::setupDotExpanderProcessorDeserializer, Builder::build);

    public DotExpanderProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.path = builder.path;
    }

    public DotExpanderProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "dot_expander";
    }

    public String field() {
        return this.field;
    }

    @Nullable
    public String path() {
        return this.path;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
    }

    protected static void setupDotExpanderProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DotExpanderProcessor> {
        private String field;
        @Nullable
        private String path;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DotExpanderProcessor build() {
            return new DotExpanderProcessor(this);
        }
    }
}

