/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardQueryCache
implements JsonpSerializable {
    private final long cacheCount;
    private final long cacheSize;
    private final long evictions;
    private final long hitCount;
    private final long memorySizeInBytes;
    private final long missCount;
    private final long totalCount;
    public static final JsonpDeserializer<ShardQueryCache> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardQueryCache::setupShardQueryCacheDeserializer, Builder::build);

    public ShardQueryCache(Builder builder) {
        this.cacheCount = Objects.requireNonNull(builder.cacheCount, "cache_count");
        this.cacheSize = Objects.requireNonNull(builder.cacheSize, "cache_size");
        this.evictions = Objects.requireNonNull(builder.evictions, "evictions");
        this.hitCount = Objects.requireNonNull(builder.hitCount, "hit_count");
        this.memorySizeInBytes = Objects.requireNonNull(builder.memorySizeInBytes, "memory_size_in_bytes");
        this.missCount = Objects.requireNonNull(builder.missCount, "miss_count");
        this.totalCount = Objects.requireNonNull(builder.totalCount, "total_count");
    }

    public ShardQueryCache(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long cacheCount() {
        return this.cacheCount;
    }

    public long cacheSize() {
        return this.cacheSize;
    }

    public long evictions() {
        return this.evictions;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public long missCount() {
        return this.missCount;
    }

    public long totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_count");
        generator.write(this.cacheCount);
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    protected static void setupShardQueryCacheDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cacheCount, JsonpDeserializer.longDeserializer(), "cache_count", new String[0]);
        op.add(Builder::cacheSize, JsonpDeserializer.longDeserializer(), "cache_size", new String[0]);
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions", new String[0]);
        op.add(Builder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count", new String[0]);
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes", new String[0]);
        op.add(Builder::missCount, JsonpDeserializer.longDeserializer(), "miss_count", new String[0]);
        op.add(Builder::totalCount, JsonpDeserializer.longDeserializer(), "total_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardQueryCache> {
        private Long cacheCount;
        private Long cacheSize;
        private Long evictions;
        private Long hitCount;
        private Long memorySizeInBytes;
        private Long missCount;
        private Long totalCount;

        public Builder cacheCount(long value) {
            this.cacheCount = value;
            return this;
        }

        public Builder cacheSize(long value) {
            this.cacheSize = value;
            return this;
        }

        public Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        public Builder hitCount(long value) {
            this.hitCount = value;
            return this;
        }

        public Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public Builder missCount(long value) {
            this.missCount = value;
            return this;
        }

        public Builder totalCount(long value) {
            this.totalCount = value;
            return this;
        }

        @Override
        public ShardQueryCache build() {
            return new ShardQueryCache(this);
        }
    }
}

