/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class OverlappingIndexTemplate
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final List<String> indexPatterns;
    public static final JsonpDeserializer<OverlappingIndexTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OverlappingIndexTemplate::setupOverlappingIndexTemplateDeserializer, Builder::build);

    public OverlappingIndexTemplate(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.indexPatterns = ModelTypeHelper.unmodifiable(builder.indexPatterns);
    }

    public OverlappingIndexTemplate(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.indexPatterns != null) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String item0 : this.indexPatterns) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupOverlappingIndexTemplateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OverlappingIndexTemplate> {
        private String name;
        @Nullable
        private List<String> indexPatterns;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder indexPatterns(@Nullable List<String> value) {
            this.indexPatterns = value;
            return this;
        }

        public Builder indexPatterns(String ... value) {
            this.indexPatterns = Arrays.asList(value);
            return this;
        }

        public Builder addIndexPatterns(String value) {
            if (this.indexPatterns == null) {
                this.indexPatterns = new ArrayList<String>();
            }
            this.indexPatterns.add(value);
            return this;
        }

        @Override
        public OverlappingIndexTemplate build() {
            return new OverlappingIndexTemplate(this);
        }
    }
}

